package com.bxm.localnews.user.facade;

import com.bxm.localnews.mq.common.model.dto.SendSmsResult;
import com.bxm.localnews.mq.common.model.dto.SmsSupplyDTO;
import com.bxm.localnews.user.facade.fallback.SmsFallbackFactory;

import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(value = "localnews-msg", fallbackFactory = SmsFallbackFactory.class)
public interface SmsFeignService {

    @GetMapping("/sms/verify/type")
    ResponseEntity<Boolean> verifySmsCodeByType(@RequestParam("type") Byte type,
                                                @RequestParam("phoneNo") String phoneNo,
                                                @RequestParam("code") String code);

    @PostMapping("/sms/tml/vcode")
    ResponseEntity<SendSmsResult> sendSmsByVCodeTemplate(@RequestBody SmsSupplyDTO smsSupplyDTO);
}
