package com.bxm.localnews.user.facade.fallback;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.user.facade.AppVersionFeignService;

import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/2/28 17:49
 * @desc
 */
@Component
@Slf4j
public class AppVersionFallbackFactory implements FallbackFactory<AppVersionFeignService> {
    @Override
    public AppVersionFeignService create(Throwable throwable) {
        return new AppVersionFeignService() {

            @Override
            public ResponseEntity<Boolean> getPublishState(BasicParam basicParam) {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(Boolean.FALSE);
            }

            @Override
            public ResponseEntity<Boolean> inWhiteList(String phone) {
                return ResponseEntity.ok(Boolean.FALSE);
            }
        };
    }
}

