package com.bxm.localnews.user.facade.fallback;

import java.util.List;

import com.bxm.localnews.user.facade.LevelConfigFeignService;
import com.bxm.localnews.user.vo.LevelConfig;
import com.google.common.collect.Lists;

import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

/**
 * @author zhaoyadong 2019/2/28 16:31
 * @desc
 */
@Component
@Slf4j
public class LevelConfigFallbackFactory implements FallbackFactory<LevelConfigFeignService> {
    @Override
    public LevelConfigFeignService create(Throwable throwable) {
        return new LevelConfigFeignService() {

            @Override
            public ResponseEntity<List<LevelConfig>> getLevelConfigs() {
                log.error(throwable.getMessage(), throwable);
                return ResponseEntity.ok(Lists.newArrayList());
            }
        };

    }
}
