package com.bxm.localnews.user.integration;

import java.math.BigDecimal;

import com.bxm.localnews.user.facade.BizLogFeignService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2019/2/28 18:09
 * @desc
 */
@Service
public class BizLogIntegrationService {

    @Autowired
    private BizLogFeignService bizLogFeignService;

    public void newUser(Long userId, String channel, String token, BigDecimal amount, String registerChannel, String rid, Integer platform) {
        bizLogFeignService.newUser(userId, channel, token, amount, registerChannel, rid, platform);
    }

    public void login(Long userId, Integer platform) {
        bizLogFeignService.login(userId, platform);
    }

    public void changeGender(Long userId, int sex, Integer platform) {
        bizLogFeignService.changeGender(userId, sex, platform);
    }

    public void changeArea(Long userId, String areaCode, Integer platform) {
        bizLogFeignService.changeArea(userId, areaCode, platform);
    }

    public void inviteSuccessed(Long userId, Long invitedUserId, Integer platform) {
        bizLogFeignService.inviteSuccessed(userId, invitedUserId, platform);
    }
}
