package com.bxm.localnews.user.integration;

import com.bxm.localnews.user.facade.VipFeignService;
import com.bxm.localnews.user.param.RecordWechatParam;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author zhaoyadong 2019/2/28 18:17
 * @desc
 */
@Service
public class VipIntegrationService {

    @Autowired
    private VipFeignService vipFeignService;

    public void saveVipViewRecord(Long userId, String unionId, Integer platform) {
        vipFeignService.saveVipViewRecord(userId, unionId, platform);
    }

    public Integer countVipByUser(Long userId) {
        return vipFeignService.countVipByUser(userId).getBody();
    }

    public void saveTempViewRecord(RecordWechatParam recordWechatParam) {
        vipFeignService.saveTempViewRecord(recordWechatParam);
    }
}
