/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.user.integration;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.common.constant.RedisMessageChannel;
import com.bxm.localnews.common.vo.RedisMessageBean;
import com.bxm.localnews.user.dto.ImgDTO;
import com.bxm.localnews.user.dto.UserImgVo;
import com.bxm.localnews.user.facade.UserNewsFeignService;
import com.bxm.localnews.user.param.UserSyncParam;
import com.bxm.localnews.user.vo.UserLikeVo;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UserNewsIntegrationService
extends BaseService {
    @Autowired
    private UserNewsFeignService userNewsFeignService;
    @Autowired
    private RedisStringAdapter redisStringAdapter;

    @Async
    public void initUserNewsImage(Long newUserId, Long defaultUserId) {
        this.userNewsFeignService.initUserImage(newUserId, defaultUserId);
    }

    public void syncUser(UserSyncParam user) {
        RedisMessageBean userSyncParamRedisMessageBean = new RedisMessageBean();
        userSyncParamRedisMessageBean.setEventBody((Object)user);
        userSyncParamRedisMessageBean.setCreateTime(new Date());
        userSyncParamRedisMessageBean.setEventCode(String.valueOf(RedisMessageChannel.USER_UPDATE_EVENT.getCode()));
        userSyncParamRedisMessageBean.setEventId(String.valueOf(this.nextSequence()));
        userSyncParamRedisMessageBean.setEventName(String.valueOf(RedisMessageChannel.USER_UPDATE_EVENT.getDesc()));
        this.logger.info("\u66f4\u65b0\u7528\u6237\u5197\u4f59\u4fe1\u606f,\u53d1\u9001redis\u6d88\u606f:[{}]", (Object)JSONObject.toJSONString((Object)user));
        this.redisStringAdapter.convertAndSend(RedisMessageChannel.USER_UPDATE_EVENT.getName(), JSONObject.toJSON((Object)userSyncParamRedisMessageBean));
    }

    public Integer getPublishPostNum(Long userId) {
        return this.userNewsFeignService.getPublishPostNum(userId);
    }

    public List<UserLikeVo> getLikeNumByUserIds(List<Long> userId) {
        ResponseEntity<List<UserLikeVo>> result = this.userNewsFeignService.getLikeNumByUserIds(userId);
        if (Objects.nonNull(result)) {
            return (List)result.getBody();
        }
        return Lists.newArrayList();
    }

    public Boolean verifySensitiveWord(String text) {
        ResponseEntity<Boolean> isSensitiveEntity = this.userNewsFeignService.verifySensitiveWord(text);
        return (Boolean)isSensitiveEntity.getBody();
    }

    public Map<Long, List<ImgDTO>> batchGetUserImg(List<Long> userIdList) {
        HashMap<Long, List<ImgDTO>> imgMap = new HashMap<Long, List<ImgDTO>>();
        ResponseEntity<List<UserImgVo>> userImgListEntity = this.userNewsFeignService.batchGetUserImg(userIdList);
        List userImgVoList = (List)userImgListEntity.getBody();
        if (!CollectionUtils.isEmpty((Collection)userImgVoList)) {
            userImgVoList.forEach(e -> {
                if (e.getImgDtoList().size() >= 4) {
                    imgMap.put(e.getUserId(), e.getImgDtoList().subList(0, 4));
                }
            });
        }
        return imgMap;
    }
}

