package com.bxm.localnews.user.model.param.earnings;

import com.bxm.localnews.common.vo.IUserIdSharding;
import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotNull;
import java.util.Date;

/**
 * @author lowi
 * @date 2020/12/11 10:04
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel("我的收益请求类")
public class UserEarningsParam extends PageParam implements IUserIdSharding {

    @ApiModelProperty("用户id")
    @NotNull(message = "用户id不能为空")
    private Long userId;

    @ApiModelProperty("订单状态 0 全部 1 待核销 2 已结算 3 待升级 4 已失效  默认为0")
    private Integer orderStatus;

    @ApiModelProperty("收益状态 0 全部 1 直卖收益  2 团队收益 默认为0")
    private Integer earningsStatus;

}
