package com.bxm.localnews.user.model.param.talent;

import com.bxm.newidea.component.vo.PageParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 团队达人列表查询入参
 *
 * @author wzy
 * @version 1.0
 * @date 2020/12/10 10:49 上午
 */
@Data
@ApiModel("团队达人列表查询入参")
public class GroupTalentListQueryParam extends PageParam {

    private static final long serialVersionUID = -8009377680356026773L;

    @ApiModelProperty("排序字段：0时间排序，1贡献订单，2贡献金额")
    private Integer orderType;

    @ApiModelProperty("排序规则：0降序，1升序，默认降序")
    private Integer orderRule;

    @ApiModelProperty("用户id")
    private Long userId;

    @ApiModelProperty("达人等级：0全部达人，1直接达人，2间接达人")
    private Integer type;
}