package com.bxm.localnews.user.enums;

/**
 * 推荐类型枚举类
 *
 * @author zhaoyadong 2019/3/7 15:12
 */
public enum RecommendTypeEnum {

    NEARBY((byte) 0, "nearby", "附近的人推荐"),

    SAME_CITY((byte) 1, "same_city", "同城人推荐");


    /**
     * id
     */
    private Byte code;

    /**
     * 名称
     */
    private String name;

    /**
     * 类型
     */
    private String desc;

    RecommendTypeEnum(Byte code, String name, String desc) {
        this.code = code;
        this.name = name;
        this.desc = desc;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Byte getCode() {
        return code;
    }

    public void setCode(Byte code) {
        this.code = code;
    }
}
