package com.bxm.localnews.user.service.barrels.weight;

import com.bxm.localnews.user.param.NativeRecommendContext;
import com.bxm.localnews.user.service.barrels.BarrelSupport;
import com.bxm.localnews.user.service.handler.WeightAlternateBarrelHandler;
import com.bxm.localnews.user.service.handler.WeightDefaultBarrelHandler;
import com.bxm.localnews.user.service.handler.WeightPreferredBarrelHandler;
import org.springframework.stereotype.Service;

/**
 * 补充剩下的条数
 */
@BarrelSupport(value = {
        WeightPreferredBarrelHandler.class,
        WeightDefaultBarrelHandler.class,
        WeightAlternateBarrelHandler.class})
@Service
public class WeightEmergencyNativeBarrel extends AbstractWeightBarrelChoose {

    @Override
    protected Boolean doInvoke(NativeRecommendContext nativeRecommendContext) {
        //如果最终推荐不足10条的话，且本地人还有余量的话，就从本地人里扣
        if (nativeRecommendContext.getResult().size() < nativeRecommendContext.getPageSize() && 0 != nativeRecommendContext.getHasSameCity()) {
            long num = Long.valueOf(nativeRecommendContext.getPageSize()) - nativeRecommendContext.getResult().size();
            doSameCityInvoke(nativeRecommendContext, num);
        }

        return true;
    }


}
