package com.bxm.localnews.user.service.impl;

import com.bxm.localnews.user.constant.RedisConfig;
import com.bxm.localnews.user.mapper.UserBlockMapper;
import com.bxm.localnews.user.service.BlockUserService;
import com.bxm.localnews.user.vo.UserBlock;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.stream.Collectors;

@Service
public class BlockUserServiceImpl implements BlockUserService {

    @Autowired
    private RedisStringAdapter redisStringAdapter;

    @Autowired
    private UserBlockMapper userBlockMapper;

    @Override
    public Boolean isBlockLimitUser(Long userId) {
        return StringUtils.isNotBlank(redisStringAdapter.getString(getBlockLimitRedisKey(userId)));
    }

    @Override
    public Boolean isRecommendLimitUser(Long userId) {
        return StringUtils.isNotBlank(redisStringAdapter.getString(getRecommendLimitRedisKey(userId)));
    }

    @Override
    @Cacheable(value = "listBlockUser", sync = true)
    public Map<Long, Integer> listBlockUser() {
        return userBlockMapper.listBlockUser().parallelStream().collect(Collectors.toMap(UserBlock::getUserId, UserBlock::getBlockType, (key1, key2) -> key1));
    }

    private KeyGenerator getBlockLimitRedisKey(Long userId) {
        return RedisConfig.USER_BLOCK_LIMIT.copy().appendKey(userId);
    }

    private KeyGenerator getRecommendLimitRedisKey(Long userId) {
        return RedisConfig.RECOMMEND_BLOCK_LIMIT.copy().appendKey(userId);
    }
}
