package com.bxm.localnews.user.service.intefaces;

import com.bxm.newidea.component.vo.BaseParam;
import org.springframework.core.Ordered;

/**
 * 定义桶处理类
 * @author 38794
 * @date 2019-10-10 15:30
 */
public interface BarrelHandler<T extends BaseParam> extends Ordered {

    /**
     * 具体处理方法
     * @param t
     * @return 具体返回什么自己定义
     */
    <R> R handle(T t);

    /**
     * 支持的处理参数
     * 哪些用户可以进入这个策略
     * @param t
     * @return
     */
    Boolean support(T t);

}
