package com.bxm.service.schedule.facade.controller;

import com.bxm.service.schedule.annotation.PermissionLimit;
import com.bxm.service.schedule.model.XxlJobInfo;
import com.bxm.service.schedule.service.XxlJobService;
import com.xxl.job.core.glue.GlueTypeEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

@Api(tags = "1-1", description = "定时任务调度相关服务接口")
@RestController
@RequestMapping("/facade/jobInfo")
public class JobInfoFacadeController {

    @Resource
    private XxlJobService xxlJobService;

    @ApiOperation(value = "1-1-1 新增任务")
    @PostMapping("/add")
    @PermissionLimit(limit = false)
    public void add(@RequestParam("jobName") String jobName,
                    @RequestParam("jobCron") String jobCron,
                    @RequestParam("jobDesc") String jobDesc,
                    @RequestParam("executorName") String executorName,
                    @RequestParam("executorHandler") String executorHandler,
                    @RequestParam("executorParam") String executorParam,
                    @RequestParam("executorRouteStrategy") String executorRouteStrategy,
                    @RequestParam("executorBlockStrategy") String executorBlockStrategy,
                    @RequestParam("author") String author) {
        XxlJobInfo jobInfo = new XxlJobInfo();
        jobInfo.setJobName(jobName);
        jobInfo.setJobCron(jobCron);
        jobInfo.setJobDesc(jobDesc);
        jobInfo.setJobGroupName(executorName);
        jobInfo.setExecutorHandler(executorHandler);
        jobInfo.setExecutorParam(executorParam);
        jobInfo.setExecutorRouteStrategy(executorRouteStrategy);
        jobInfo.setExecutorBlockStrategy(executorBlockStrategy);
        jobInfo.setGlueType(GlueTypeEnum.BEAN.name());
        jobInfo.setAuthor(author);
        xxlJobService.add(jobInfo);
        xxlJobService.start(jobInfo.getId());
    }

    @ApiOperation(value = "1-1-2 更新任务")
    @PostMapping("/update")
    @PermissionLimit(limit = false)
    public void update(@RequestParam("jobName") String jobName,
                    @RequestParam("jobCron") String jobCron,
                    @RequestParam("jobDesc") String jobDesc,
                    @RequestParam("executorName") String executorName,
                    @RequestParam("executorHandler") String executorHandler,
                    @RequestParam("executorParam") String executorParam,
                    @RequestParam("executorRouteStrategy") String executorRouteStrategy,
                    @RequestParam("executorBlockStrategy") String executorBlockStrategy,
                    @RequestParam("author") String author) {
        XxlJobInfo jobInfo = new XxlJobInfo();
        jobInfo.setJobName(jobName);
        jobInfo.setJobCron(jobCron);
        jobInfo.setJobDesc(jobDesc);
        jobInfo.setJobGroupName(executorName);
        jobInfo.setExecutorHandler(executorHandler);
        jobInfo.setExecutorParam(executorParam);
        jobInfo.setExecutorRouteStrategy(executorRouteStrategy);
        jobInfo.setExecutorBlockStrategy(executorBlockStrategy);
        jobInfo.setGlueType(GlueTypeEnum.BEAN.name());
        jobInfo.setAuthor(author);
        xxlJobService.remove(jobName);
        xxlJobService.add(jobInfo);
        xxlJobService.start(jobInfo.getId());
    }

    @ApiOperation(value = "1-1-3 移除任务")
    @PostMapping("/remove")
    @PermissionLimit(limit = false)
    public void remove(@RequestParam("jobName") String jobName) {
        xxlJobService.remove(jobName);
    }

}
