/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.wanzhuan.activity.service.impl;

import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.wanzhuan.activity.domain.LevelConfigMapper;
import com.bxm.newidea.wanzhuan.activity.model.LevelConfig;
import com.bxm.newidea.wanzhuan.activity.service.LevelConfigService;
import com.bxm.newidea.wanzhuan.base.constant.RedisConfig;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LevelConfigServiceImpl
implements LevelConfigService {
    private LevelConfigMapper levelConfigMapper;
    private RedisStringAdapter redisStringAdapter;

    @Autowired
    public LevelConfigServiceImpl(LevelConfigMapper levelConfigMapper, RedisStringAdapter redisStringAdapter) {
        this.levelConfigMapper = levelConfigMapper;
        this.redisStringAdapter = redisStringAdapter;
    }

    public List<LevelConfig> getLevelConfigs() {
        List<LevelConfig> result = (List<LevelConfig>)this.redisStringAdapter.get(RedisConfig.USER_LEVEL_CONFIG);
        if (CollectionUtils.isEmpty((Collection)result)) {
            result = this.levelConfigMapper.listAll();
            this.redisStringAdapter.set(RedisConfig.USER_LEVEL_CONFIG, result, 604800L);
        }
        return result;
    }

    public LevelConfig selectByPrimaryKey(Long id) {
        List<LevelConfig> levelConfigs = this.getLevelConfigs();
        for (LevelConfig config : levelConfigs) {
            if (null == id || !id.equals(config.getId())) continue;
            return config;
        }
        return null;
    }
}

