/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.wanzhuan.activity.service.impl;

import com.bxm.newidea.common.util.ResultUtil;
import com.bxm.newidea.component.log.LogMarker;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.wanzhuan.activity.domain.DailyTaskMapper;
import com.bxm.newidea.wanzhuan.activity.enums.TaskTypeEnum;
import com.bxm.newidea.wanzhuan.activity.model.BaskInfoMeta;
import com.bxm.newidea.wanzhuan.activity.model.DailyTask;
import com.bxm.newidea.wanzhuan.activity.model.MissionModel;
import com.bxm.newidea.wanzhuan.activity.model.UserMissionModel;
import com.bxm.newidea.wanzhuan.activity.service.MissionService;
import com.bxm.newidea.wanzhuan.base.constant.AppConst;
import com.bxm.newidea.wanzhuan.base.constant.RedisConfig;
import com.bxm.newidea.wanzhuan.base.service.SysConfigRedis;
import com.bxm.newidea.wanzhuan.base.vo.Json;
import com.bxm.newidea.wanzhuan.points.service.BusinessCalService;
import com.bxm.newidea.wanzhuan.points.service.PayFlowService;
import com.bxm.newidea.wanzhuan.points.service.UserAmountService;
import com.bxm.newidea.wanzhuan.points.vo.PayFlow;
import com.bxm.newidea.wanzhuan.points.vo.UserAmount;
import com.bxm.newidea.wanzhuan.security.model.User;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="missionService")
public class MissionServiceImpl
implements MissionService {
    private static final Logger logger = LoggerFactory.getLogger(MissionServiceImpl.class);
    @Resource
    private DailyTaskMapper dailyTaskMapper;
    private PayFlowService payFlowService;
    @Resource
    private SysConfigRedis sysConfigRedis;
    @Resource
    private UserAmountService userAmountService;
    @Resource
    private BusinessCalService businessCalService;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    private PayFlowService getPayFlowService() {
        if (null == this.payFlowService) {
            this.payFlowService = (PayFlowService)SpringContextHolder.getBean(PayFlowService.class);
        }
        return this.payFlowService;
    }

    public Json<MissionModel> listMissions(Long userId) {
        MissionModel retModel = new MissionModel();
        retModel.setHotImg(this.sysConfigRedis.getValue("BUSINESS", "hot_img_url"));
        List<UserMissionModel> userTask = this.dailyTaskMapper.listMissions(userId);
        Map<String, Byte> dailyTaskMap = this.getDailyTaskStatus(userId);
        int count = 0;
        for (UserMissionModel model : userTask) {
            if (DailyTask.NEWBIEW_TASK.equals(model.getType())) {
                retModel.addNewbieTask(model);
                if (1 == model.getNewbiewTaskState()) {
                    ++count;
                }
                if (model.getNewbiewTaskCount() != count) continue;
                retModel.setNewbieTaskList(new ArrayList());
                continue;
            }
            model.setState(Byte.valueOf(dailyTaskMap.get(model.getId().toString()) == null ? (byte)0 : 1));
            retModel.addDailyTask(model);
        }
        retModel = this.sortResult(retModel);
        return ResultUtil.genSuccessResult((Object)retModel);
    }

    private MissionModel sortResult(MissionModel retModel) {
        this.sortList(retModel.getNewbieTaskList());
        this.sortList(retModel.getDailyTaskList());
        return retModel;
    }

    private void sortList(List<UserMissionModel> list) {
        list.sort(Comparator.comparingInt(UserMissionModel::getNewbiewTaskState));
    }

    public Json shareReward(Byte shareType, Long userId) {
        Json result = ResultUtil.genSuccessResult();
        if (1 == shareType) {
            result = this.shareFriendReward(userId);
        } else if (2 == shareType) {
            result = this.shareFriendCircleReward(userId);
        } else if (3 == shareType) {
            result = this.baskIncomeReward(userId);
        }
        return result;
    }

    private String getCurrentDateStr() {
        return ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_FORMAT.get()).format(new Date());
    }

    private Json shareFriendCircleReward(Long userId) {
        KeyGenerator key = RedisConfig.TASK_SHARE_MEMENTS.copy().setKey(userId + this.getCurrentDateStr());
        int number = this.getRedisNum(key, 3);
        if (number <= 0) {
            return ResultUtil.genSuccessResult();
        }
        if (number == 1) {
            this.compleDailyTask(userId, TaskTypeEnum.ECRUIT_BY_SHARE_FRIEND.getType());
        }
        PayFlow payFlow = PayFlow.initPayFlow((Long)userId, (Byte)TaskTypeEnum.ECRUIT_BY_SHARE_FRIEND.getType(), (Byte)10, null);
        this.getPayFlowService().modifyAccountFlowAndStatByGold(payFlow, AppConst.SHARE_FRIEND_GOLD_NUM, false);
        this.redisStringAdapter.set(key, (Object)(number - 1 + ""), (long)DateUtils.getCurSeconds());
        return ResultUtil.genSuccessResult();
    }

    private Json shareFriendReward(Long userId) {
        KeyGenerator key = RedisConfig.TASK_SHARE_WECHAT_FRINED.copy().setKey(userId.toString() + this.getCurrentDateStr());
        int number = this.getRedisNum(key, 3);
        if (number <= 0) {
            return ResultUtil.genSuccessResult();
        }
        if (number == 1) {
            this.compleDailyTask(userId, TaskTypeEnum.ECRUIT_BY_SHARE_WEIXIN.getType());
        }
        PayFlow payFlow = PayFlow.initPayFlow((Long)userId, (Byte)TaskTypeEnum.ECRUIT_BY_SHARE_WEIXIN.getType(), (Byte)10, null);
        this.getPayFlowService().modifyAccountFlowAndStatByGold(payFlow, AppConst.SHARE_WEIXIN_GOLD_NUM, false);
        this.redisStringAdapter.set(key, (Object)(number - 1 + ""), (long)DateUtils.getCurSeconds());
        return ResultUtil.genSuccessResult();
    }

    private Json baskIncomeReward(Long userId) {
        KeyGenerator key = RedisConfig.TASK_BASK_INCOME.copy().setKey(userId + this.getCurrentDateStr());
        int number = this.getRedisNum(key, 3);
        if (number <= 0) {
            return ResultUtil.genSuccessResult();
        }
        if (number == 1) {
            this.compleDailyTask(userId, TaskTypeEnum.DIVULGE_INCOME.getType());
        }
        PayFlow payFlow = PayFlow.initPayFlow((Long)userId, (Byte)TaskTypeEnum.DIVULGE_INCOME.getType(), (Byte)10, null);
        this.getPayFlowService().modifyAccountFlowAndStatByGold(payFlow, AppConst.BASK_INCOME_GOLD_NUM, false);
        this.redisStringAdapter.set(key, (Object)(number - 1 + ""), (long)DateUtils.getCurSeconds());
        return ResultUtil.genSuccessResult();
    }

    private int getRedisNum(KeyGenerator key, int typeNum) {
        String num = (String)this.redisStringAdapter.get(key);
        return StringUtils.isNotBlank((CharSequence)num) ? Integer.valueOf(num) : typeNum;
    }

    public void grantLevelSubsidy(User user) {
        BigDecimal gold = this.businessCalService.calculateSubsidyGold(user.getLevel());
        if (this.getPayFlowService().hasGrantSubsidyThisMonth(user.getId(), gold)) {
            logger.info("\u5df2\u9886\u53d6\u7b49\u7ea7\u5956\u52b1,userId:" + user.getId());
            return;
        }
        PayFlow payFlow = PayFlow.initPayFlow((Long)user.getId(), (Byte)TaskTypeEnum.LEVEL_REWARD_PER_MONTH.getType(), (Byte)10, null);
        this.getPayFlowService().modifyAccountFlowAndStatByGold(payFlow, gold, false);
    }

    public Json<BaskInfoMeta> baskInfo(Long userId) {
        UserAmount userAmount = this.userAmountService.selectByUserId(userId);
        BaskInfoMeta meta = new BaskInfoMeta();
        meta.setInviteCode(userAmount.getUserId());
        meta.setTotalCoin(userAmount.getTotalRmbBalance());
        return ResultUtil.genSuccessResult((Object)meta);
    }

    public void compleDailyTask(Long userId, Byte taskId) {
        Assert.notNull((Object)taskId, (String)"\u4efb\u52a1ID\u4e0d\u80fd\u4e3a\u7a7a");
        logger.info(LogMarker.BIZ, "[{}]\u5b8c\u6210\u4e86\u4efb\u52a1[{}]", (Object)userId, (Object)taskId);
        KeyGenerator key = this.getDailyTaskCacheKey(userId);
        this.redisHashMapAdapter.put(key, taskId.toString(), (Object)1);
        this.redisHashMapAdapter.expire(key, (long)DateUtils.getCurSeconds());
    }

    private KeyGenerator getDailyTaskCacheKey(Long userId) {
        return RedisConfig.DAILY_TASK_COMPELE_STATUS.copy().setKey(DateUtils.formatDate((Date)new Date()) + userId);
    }

    public Map<String, Byte> getDailyTaskStatus(Long userId) {
        Assert.notNull((Object)userId, (String)"\u7528\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
        Map result = this.redisHashMapAdapter.entries(this.getDailyTaskCacheKey(userId));
        if (result == null) {
            result = Maps.newHashMap();
        }
        return result;
    }
}

