/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.wanzhuan.activity.service.impl;

import com.bxm.newidea.common.util.ResultUtil;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redis.impl.RedisKeyGenerator;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.wanzhuan.activity.domain.SignConfigMapper;
import com.bxm.newidea.wanzhuan.activity.domain.SignRecordMapper;
import com.bxm.newidea.wanzhuan.activity.enums.TaskTypeEnum;
import com.bxm.newidea.wanzhuan.activity.service.SignService;
import com.bxm.newidea.wanzhuan.activity.vo.SignConfig;
import com.bxm.newidea.wanzhuan.activity.vo.SignJson;
import com.bxm.newidea.wanzhuan.activity.vo.SignRecord;
import com.bxm.newidea.wanzhuan.activity.vo.SignWarper;
import com.bxm.newidea.wanzhuan.base.constant.RedisConfig;
import com.bxm.newidea.wanzhuan.base.service.OSSService;
import com.bxm.newidea.wanzhuan.base.vo.Json;
import com.bxm.newidea.wanzhuan.points.service.PayFlowService;
import com.bxm.newidea.wanzhuan.points.vo.PayFlow;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SignServiceImpl
implements SignService {
    private static final Logger logger = LoggerFactory.getLogger(SignServiceImpl.class);
    private static final String INIT_TABLE_NAME = "b_sign_record";
    private static final int EXPIRE_TIME = 604800;
    private static final int SIGN_LIST_LENGTH = 8;
    private static final int TOTAL_SIGN_IMG = 30;
    @Resource
    private SignConfigMapper signConfigMapper;
    @Resource
    private SignRecordMapper signRecordMapper;
    @Resource
    private PayFlowService payFlowService;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private OSSService ossService;

    @Override
    public Json<SignWarper> doSignAndListSignRecord(Long userId, int platform) {
        SignWarper warper = new SignWarper();
        List<SignRecord> signRecords = this.listUserSignRecord(userId);
        Date today = new Date();
        for (SignRecord record : signRecords) {
            if (!org.apache.commons.lang3.time.DateUtils.isSameDay((Date)record.getSignDate(), (Date)today) || !record.getSignFlag().booleanValue()) continue;
            warper.setTodaySignState(true);
            break;
        }
        if (!warper.isTodaySignState()) {
            logger.debug("\u4eca\u65e5\u672a\u7b7e\u5230\uff0c\u81ea\u52a8\u8fdb\u884c\u7b7e\u5230,user:[{}]", (Object)userId);
            this.doDailySign(userId);
            signRecords = this.listUserSignRecord(userId);
            warper.setAutoSign(true);
            warper.setTodaySignState(true);
            this.getSignImgUrl(userId, platform, warper);
        } else {
            this.getCurrentSignImgUrl(userId, platform, warper);
        }
        warper.setRecords(signRecords);
        warper.setCount(this.getSignCount(userId));
        return ResultUtil.genSuccessResult((Object)warper);
    }

    private void getCurrentSignImgUrl(Long userId, int platform, SignWarper warper) {
        Long currentIndex = this.redisStringAdapter.getLong(RedisConfig.SIGN_IMAGE_INDEX.copy().setKey(userId.toString()));
        this.fillImgUrl(currentIndex, platform, warper);
    }

    private void fillImgUrl(long index, int platform, SignWarper warper) {
        if ((index %= 30L) == 0L) {
            index = 30L;
        }
        if (platform != 1 && platform != 2) {
            platform = 1;
        }
        int sizeType = 1;
        String imgPathRoot = this.ossService.getOSSFileRoot() + "sign/" + index + "-" + platform + "-" + sizeType;
        warper.setSignImg(imgPathRoot + ".png");
        warper.setSignShareImg(imgPathRoot + "-share.png");
    }

    private void getSignImgUrl(Long userId, int platform, SignWarper warper) {
        long index = this.redisStringAdapter.incrementWithDefault(RedisConfig.SIGN_IMAGE_INDEX.copy().setKey(userId.toString()), (long)RandomUtils.nextInt((int)1, (int)31));
        this.fillImgUrl(index, platform, warper);
    }

    private KeyGenerator getSignCountKey(Long userId) {
        return RedisKeyGenerator.build((String)(RedisConfig.SIGN_COUNT_KEY + userId));
    }

    private KeyGenerator getSignListKey(Long userId) {
        return RedisKeyGenerator.build((String)(RedisConfig.SIGN_LIST_KEY + userId));
    }

    private int getSignCount(Long userId) {
        Integer count = this.redisStringAdapter.getInt(this.getSignCountKey(userId));
        return count == null ? 1 : count;
    }

    private void resetSignCount(Long userId) {
        this.redisStringAdapter.set(this.getSignCountKey(userId), 0L);
    }

    @Override
    public SignJson doDailySign(Long userId) {
        List<SignRecord> signRecords = this.listUserSignRecord(userId);
        logger.debug("\u6267\u884c\u7b7e\u5230:[{}]", (Object)userId);
        Date today = new Date();
        for (SignRecord record : signRecords) {
            if (!org.apache.commons.lang3.time.DateUtils.isSameDay((Date)record.getSignDate(), (Date)today) || !record.getSignFlag().booleanValue()) continue;
            logger.debug("\u91cd\u590d\u7b7e\u5230:[{}]", (Object)userId);
            return SignJson.build(Json.build((int)-200, (String)"\u4eca\u65e5\u5df2\u7b7e\u5230"));
        }
        SignRecord record = this.saveSignRecord(userId);
        for (SignRecord cacheRecord : signRecords) {
            if (!org.apache.commons.lang3.time.DateUtils.isSameDay((Date)cacheRecord.getSignDate(), (Date)today)) continue;
            cacheRecord.setSignFlag(true);
            break;
        }
        this.redisStringAdapter.set(this.getSignListKey(userId), signRecords);
        return SignJson.build(Json.build()).setReward(record.getSignReward());
    }

    private SignRecord saveSignRecord(Long userId) {
        long reward = this.getSignReward(userId);
        Long count = this.redisStringAdapter.increment(this.getSignCountKey(userId));
        logger.debug("\u7b7e\u5230\u6210\u529f\uff0c\u5f53\u524d\u5929\u6570\uff1a[{}]", (Object)userId, (Object)count);
        SignRecord record = new SignRecord();
        record.setSignDate(new Date());
        record.setSignReward(reward);
        record.setSignDay(count.intValue());
        record.setUserId(userId);
        this.signRecordMapper.insertSelective(record, this.getSignTableName(userId));
        PayFlow payFlow = PayFlow.initPayFlow((Long)userId, (Byte)TaskTypeEnum.SIGN_DAILY.getType(), (Byte)10, (String)record.getId().toString());
        this.payFlowService.modifyAccountFlowAndStatByGold(payFlow, new BigDecimal(reward), false);
        return record;
    }

    private long getSignReward(Long userId) {
        List<SignConfig> signConfigs = this.getSignconfigInfo();
        int count = this.getSignCount(userId);
        if (count >= 8) {
            return signConfigs.get(7).getReward();
        }
        return signConfigs.get(count).getReward();
    }

    private boolean getLastUnSignRecord(List<SignRecord> records) {
        SignRecord lastRecord = null;
        for (SignRecord record : records) {
            if (record.getSignFlag().booleanValue()) continue;
            lastRecord = record;
            break;
        }
        Date today = new Date();
        return null != lastRecord && (org.apache.commons.lang3.time.DateUtils.isSameDay((Date)today, (Date)lastRecord.getSignDate()) || org.apache.commons.lang3.time.DateUtils.isSameDay((Date)DateUtils.addField((Date)lastRecord.getSignDate(), (int)5, (int)-1), (Date)today));
    }

    private List<SignRecord> listUserSignRecord(Long userId) {
        boolean isSequential;
        Date today = new Date();
        List<SignRecord> records = (List<SignRecord>)this.redisStringAdapter.get(this.getSignListKey(userId));
        if (CollectionUtils.isNotEmpty((Collection)records)) {
            SignRecord lastRecord = (SignRecord)((Object)records.get(records.size() - 1));
            if (org.apache.commons.lang3.time.DateUtils.isSameDay((Date)DateUtils.addField((Date)lastRecord.getSignDate(), (int)5, (int)1), (Date)today)) {
                records = this.buildSignList(this.getSignCount(userId), today, userId, true);
            } else if (!this.getLastUnSignRecord(records)) {
                records = this.buildSignList(0, today, userId, true);
                this.resetSignCount(userId);
            }
            return records;
        }
        SignRecord record = this.signRecordMapper.getLastSignRecord(userId, this.getSignTableName(userId));
        boolean bl = isSequential = record != null && (org.apache.commons.lang3.time.DateUtils.isSameDay((Date)today, (Date)record.getSignDate()) || org.apache.commons.lang3.time.DateUtils.isSameDay((Date)DateUtils.addField((Date)record.getSignDate(), (int)5, (int)1), (Date)today));
        if (isSequential) {
            records = this.buildSignList(this.getSignCount(userId), record.getSignDate(), userId, false);
        } else {
            records = this.buildSignList(0, today, userId, true);
            this.resetSignCount(userId);
        }
        return records;
    }

    private List<SignRecord> buildSignList(int startIndex, Date startDate, Long userId, boolean newList) {
        ArrayList records = Lists.newArrayList();
        List<SignConfig> signConfigs = this.getSignconfigInfo();
        int startNum = startIndex > 8 ? (startIndex - 1) / 8 * 8 : 0;
        int actulStartIndex = startIndex % 8;
        if (startIndex > 0 && actulStartIndex == 0) {
            actulStartIndex = 8;
        } else if (startIndex == 0) {
            actulStartIndex = 1;
        }
        for (int i = 0; i < 8; ++i) {
            SignRecord record = new SignRecord();
            int signDay = i + 1 + startNum;
            record.setSignDay(signDay);
            if (startIndex == 0) {
                record.setSignDate(DateUtils.addField((Date)startDate, (int)5, (int)i));
            } else {
                record.setSignDate(DateUtils.addField((Date)startDate, (int)5, (int)(i + 1 - actulStartIndex)));
            }
            if (newList) {
                record.setSignFlag(false);
            } else {
                record.setSignFlag(startIndex >= signDay);
            }
            if (signDay >= 8) {
                record.setSignReward(signConfigs.get(7).getReward());
            } else {
                record.setSignReward(signConfigs.get(i).getReward());
            }
            records.add(record);
        }
        this.redisStringAdapter.set(this.getSignListKey(userId), (Object)records, 604800L);
        return records;
    }

    private String getSignTableName(Long userId) {
        return "b_sign_record_" + userId % 10L;
    }

    private List<SignConfig> getSignconfigInfo() {
        RedisKeyGenerator key = RedisKeyGenerator.build((String)RedisConfig.SIGN_CACHE_KEY);
        List redisRet = (List)this.redisStringAdapter.get((KeyGenerator)key);
        if (CollectionUtils.isNotEmpty((Collection)redisRet)) {
            return redisRet;
        }
        List<SignConfig> list = this.signConfigMapper.listAll();
        this.redisStringAdapter.set((KeyGenerator)key, list, 604800L);
        return list;
    }
}

