package com.bxm.newidea.wanzhuan.activity.controller;

import com.bxm.newidea.common.annotation.TouTiaoAuth;
import com.bxm.newidea.common.util.ResultUtil;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.wanzhuan.activity.service.ActivityService;
import com.bxm.newidea.wanzhuan.activity.vo.Activity;
import com.bxm.newidea.wanzhuan.base.vo.RdPage;
import com.github.pagehelper.Page;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@Api(tags = "2-10 [管理]活动查询")
@RestController
@RequestMapping("api/activity")
public class ActivityController extends BaseController {

    @Resource
    private ActivityService activityService;

    @RequestMapping("selectPageList")
    @TouTiaoAuth
    public Object selectPageList(Integer current, Integer pageSize) {
        Page<Activity> page = this.activityService.selectPageList(current, pageSize);
        return ResultUtil.genSuccessResultWithPage(page, new RdPage(page));
    }
}
