package com.bxm.newidea.wanzhuan.activity.controller;

import com.bxm.newidea.common.util.ResultUtil;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.wanzhuan.activity.service.ActivityService;
import com.bxm.newidea.wanzhuan.activity.vo.Activity;
import com.bxm.newidea.wanzhuan.activity.vo.ActivityDTO;
import com.bxm.newidea.wanzhuan.base.vo.RdPage;
import io.swagger.annotations.Api;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.text.ParseException;
import java.text.SimpleDateFormat;

@Api(tags = "2-09 [管理]活动管理")
@RestController
@RequestMapping("api/admin/activity")
public class AdminActivityController {

    @Resource
    private ActivityService activityService;


    /**
     * 获取活动列表
     * @param activityDTO
     * @return
     */
    @RequestMapping("/list")
    @RequiresPermissions("admin:activity")
    public Object getActivityList(ActivityDTO activityDTO) {
        RdPage rdPage = new RdPage();
        rdPage.setCurPage(activityDTO.getCurPage());
        rdPage.setPageSize(activityDTO.getPageSize());
        rdPage.setItemTotal(this.activityService.getActivityCount(activityDTO));
        return ResultUtil.genSuccessResultWithPage(this.activityService.getActivityByParams(activityDTO), rdPage);

    }


    /**
     * 活动批量上下架
     * @param ids
     * @param state
     * @return
     */
    @RequestMapping("/batchUpdateActivity")
    @RequiresPermissions("admin:activity")
    public Object updateActivityStatusByIds(String ids, Byte state) {
        String idsNew = ids.substring(1, ids.length() - 1);
        String id[] = idsNew.split(",");
        if (id.length > 0) {
            int flag = this.activityService.updateActivityStateByIds(id, state);
            if (flag > 0) {
                return ResultUtil.genSuccessMsg("更新成功");
            }
            return ResultUtil.genFailedResult("更新失败");
        } else {
            return ResultUtil.genFailedResult("请选择新闻");
        }
    }

    /**
     * 获取活动详情
     * @param id
     * @return
     */
    @RequestMapping("/getActivityDetail")
    @RequiresPermissions("admin:activity")
    public Object getActivityDetail(Long id) {
        return ResultUtil.genSuccessResult(this.activityService.selectByPrimaryKey(id));
    }


    /**
     * 任务开启，下架
     * @param id
     * @param state
     * @return
     */
    @RequestMapping("/updateActivity")
    @RequiresPermissions("admin:activity")
    public Object updateActivityStatusById(Long id, Byte state) {
        Activity activity = new Activity();
        activity.setId(id);
        activity.setState(state);
        int flag = this.activityService.updateByPrimaryKeySelective(activity);
        if (flag > 0) {
            return ResultUtil.genSuccessMsg("更新成功");
        }
        return ResultUtil.genFailedResult("更新失败");
    }


    /**
     * 新增或编辑活动
     * @param startTime
     * @param endTime
     * @param name
     * @param activityPic
     * @param activityUrl
     * @param id
     * @param state
     * @param remark
     * @return
     * @throws ParseException
     */
    @RequestMapping("/saveOrUpdateActivity")
    @RequiresPermissions("admin:activity")
    public Object addAdvertDetail(@RequestParam(value = "startTime", required = false) String startTime,
                                  @RequestParam(value = "endTime", required = false) String endTime,
                                  @RequestParam(value = "name", required = false) String name,
                                  @RequestParam(value = "activityPic", required = false) String activityPic,
                                  @RequestParam(value = "activityUrl", required = false) String activityUrl,
                                  @RequestParam(value = "id", required = false) String id,
                                  @RequestParam(value = "state", required = false) String state,
                                  @RequestParam(value = "remark", required = false) String remark
    ) throws ParseException {

        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        int flag = 0;
        Activity activity = new Activity(name, activityPic, activityUrl, sdf.parse(startTime), sdf.parse(endTime), Byte.valueOf(state), remark);
        if (StringUtils.isEmpty(id)) {
            flag = this.activityService.insertSelective(activity);
        } else {
            activity.setId(Long.parseLong(id));
            flag = this.activityService.updateByPrimaryKeySelective(activity);
        }
        if (flag <= 0) {
            return ResultUtil.genFailedResult("操作失败");
        }
        return ResultUtil.genSuccessMsg("操作成功");
    }


}
