package com.bxm.newidea.wanzhuan.activity.controller;

import com.bxm.newidea.common.util.ResultUtil;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.wanzhuan.activity.model.DailyTask;
import com.bxm.newidea.wanzhuan.activity.service.DailyTaskService;
import com.bxm.newidea.wanzhuan.activity.vo.TaskDTO;
import com.bxm.newidea.wanzhuan.base.vo.RdPage;
import io.swagger.annotations.Api;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;


@Api(tags = "2-10 [管理]任务管理")
@RestController
@RequestMapping("api/admin/task")
public class AdminTaskController extends BaseController {

    @Resource
    private DailyTaskService dailyTaskService;

    //获取任务列表
    @RequestMapping("/list")
    @RequiresPermissions("admin:task")
    public Object getTask(TaskDTO taskDTO) {
        RdPage rdPage = new RdPage();
        rdPage.setCurPage(taskDTO.getCurPage());
        rdPage.setPageSize(taskDTO.getPageSize());
        rdPage.setItemTotal(this.dailyTaskService.getTaskCount(taskDTO));
        return ResultUtil.genSuccessResultWithPage(this.dailyTaskService.getTaskByParams(taskDTO), rdPage);
    }

    //任务批量上下架
    @RequestMapping("/batchUpdateTasks")
    @RequiresPermissions("admin:task")
    public Object updateNewsStatusByIds(String ids, Byte state) {
        String idsNew = ids.substring(1, ids.length() - 1);
        String id[] = idsNew.split(",");
        if (id.length > 0) {
            int flag = this.dailyTaskService.updateTaskStateByIds(id, state);
            if (flag > 0) {
                return ResultUtil.genSuccessMsg("更新成功");
            }
            return ResultUtil.genFailedResult("更新失败");
        } else {
            return ResultUtil.genFailedResult("请选择新闻");
        }
    }

    //获取任务详情
    @RequestMapping("/getTaskDetail")
    @RequiresPermissions("admin:task")
    public Object getNewsDetail(Long id) {
        return ResultUtil.genSuccessResult(this.dailyTaskService.selectByPrimaryKey(id));
    }


    //任务开启，下架
    @RequestMapping("/updateTask")
    @RequiresPermissions("admin:task")
    public Object updateNewsStatusById(Long id, Byte state) {
        DailyTask task = new DailyTask();
        task.setId(id);
        task.setState(state);
        int flag = this.dailyTaskService.updateByPrimaryKeySelective(task);
        if (flag > 0) {
            return ResultUtil.genSuccessMsg("更新成功");
        }
        return ResultUtil.genFailedResult("更新失败");
    }


}










