package com.bxm.newidea.wanzhuan.activity.controller;

import com.bxm.newidea.common.annotation.TouTiaoAuth;
import com.bxm.newidea.component.tools.WebUtils;
import com.bxm.newidea.wanzhuan.activity.model.PrenticeRankingModel;
import com.bxm.newidea.wanzhuan.activity.service.InviteRelationService;
import com.bxm.newidea.wanzhuan.base.constant.AppConst;
import com.bxm.newidea.wanzhuan.base.vo.Json;
import com.bxm.newidea.wanzhuan.points.service.UserRewardStatService;
import com.bxm.newidea.wanzhuan.points.vo.PrenticeStatModel;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.List;

@Api(tags = "2-03 师徒相关")
@RestController
@RequestMapping("api/apprenticeship")
public class ApprenticeshipController {

    @Resource
    private UserRewardStatService userRewardStatService;

    @Resource
    private InviteRelationService inviteRelationService;

    @ApiOperation("2-03-1 我的徒弟界面")
    @ApiImplicitParam(name = "userId", value = "用户ID")
    @PostMapping(value = "myPrentice")
    @TouTiaoAuth
    public Json<PrenticeStatModel> myPrentice(@RequestParam(name = "userId") Long userId) {
        return this.userRewardStatService.prenticeStatDaily(userId);
    }

    @ApiOperation(value = "2-03-2 我的徒孙界面", hidden = true)
    @PostMapping(value = "myDispline")
    @TouTiaoAuth
    public Object myDispline(@RequestParam(name = "userId") Long userId) {
        return this.userRewardStatService.displineStatDaily(userId);
    }

    @ApiOperation("2-03-3 高手排行榜")
    @PostMapping(value = "topRanking")
    @TouTiaoAuth
    public Json<List<PrenticeRankingModel>> topRanking() {
        return this.userRewardStatService.topRanking();
    }

    @ApiOperation("2-03-4 唤醒完成")
    @PostMapping(value = "awakePrentices")
    @TouTiaoAuth
    public Object awake(@RequestParam(name = "ids") Long[] ids,
                        @RequestParam(name = "userId") Long userId) {
        return this.inviteRelationService.awakePrenticesSuccess(ids, userId);
    }

    @ApiOperation(value = "2-03-5 一键唤醒")
    @PostMapping(value = "awakeAll")
    @TouTiaoAuth
    public Json awakeAll(@RequestParam(name = "userId") Long userId, HttpServletRequest request) {
        return this.inviteRelationService.awakeAllPrentices(userId, WebUtils.getIpAddr(request));
    }

    @ApiOperation(value = "2-03-6 唤醒徒儿")
    @PostMapping(value = "awakePrentice")
    @TouTiaoAuth
    public Object awakePrentice(@RequestParam(name = "userId") Long userId,
                                @RequestParam(name = "prenticeId") Long prenticeId,
                                HttpServletRequest request) {
        return this.inviteRelationService.awakePrentice(userId, prenticeId, request.getRemoteAddr());
    }

    @ApiOperation("2-03-7 获取邀请收徒信息")
    @PostMapping(value = "getShareApprenticeMessage")
    @TouTiaoAuth
    public Object getShareApprenticeMessage(@RequestParam(value = "userId") Long userId) {
        return this.inviteRelationService.getShareMessage(userId, AppConst.SHARE_INFO_TYPE.APPRENTICE);
    }

    @ApiOperation("2-03-8 获取唤醒信息")
    @PostMapping(value = "getShareAwakenMessage")
    @TouTiaoAuth
    public Object getShareAwakenMessage(@RequestParam(value = "userId") Long userId) {
        return this.inviteRelationService.getShareMessage(userId, AppConst.SHARE_INFO_TYPE.AWAKEN);
    }

    @ApiOperation("2-03-9 拜师界面信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID"),
            @ApiImplicitParam(name = "type", value = "type 1：站内扫-拜师 2：站外扫注册并拜师界面")
    })
    @PostMapping(value = "getApprenticeInfo")
    @ResponseBody
    public Object getApprenticeInfo(@RequestParam(value = "userId") Long userId,
                                    @RequestParam(value = "type") Byte type) {
        return this.inviteRelationService.getApprenticeInfo(userId, type);
    }

}
