package com.bxm.newidea.wanzhuan.activity.controller;

import com.bxm.newidea.common.annotation.TouTiaoAuth;
import com.bxm.newidea.wanzhuan.activity.service.SignService;
import com.bxm.newidea.wanzhuan.activity.vo.SignJson;
import com.bxm.newidea.wanzhuan.activity.vo.SignWarper;
import com.bxm.newidea.wanzhuan.base.vo.Json;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@Api(tags = "2-01 每日签到接口", description = "签到必须登录后才可以访问")
@RestController
@RequestMapping("api/sign")
public class DailySignController {

    @Resource
    private SignService signService;

    @ApiOperation(value = "2-01-1 获取用户的签到记录", notes = "如果今日未签到将自动进行签到，签到返回信息中包含签到图片")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID"),
            @ApiImplicitParam(name = "platform", value = "平台，1：安卓，2：IOS")
    })
    @PostMapping(value = "listSignRecord")
    @TouTiaoAuth
    public Json<SignWarper> listSignRecord(@RequestParam(value = "userId") Long userId, @RequestParam(value = "platform") int platform) {
        return this.signService.doSignAndListSignRecord(userId, platform);
    }

    @ApiOperation(value = "2-01-2 今日签到", hidden = true)
    @ApiImplicitParam(name = "userId", value = "签到的用户ID")
    @PostMapping(value = "dailySign")
    @TouTiaoAuth
    public SignJson dailySign(@RequestParam(value = "userId") Long userId) {
        return this.signService.doDailySign(userId);
    }
}
