package com.bxm.newidea.wanzhuan.activity.controller;

import com.bxm.newidea.common.annotation.TouTiaoAuth;
import com.bxm.newidea.wanzhuan.activity.model.BaskInfoMeta;
import com.bxm.newidea.wanzhuan.activity.model.MissionModel;
import com.bxm.newidea.wanzhuan.activity.service.MissionService;
import com.bxm.newidea.wanzhuan.base.vo.Json;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@Api(tags = "2-02 个人任务相关接口", description = "包括新手任务和日常任务")
@RestController
@RequestMapping("api/mission")
public class MissionController {

    @Resource
    private MissionService missionService;

    @ApiOperation("2-02-1 获取任务中心列表,包括个人任务和新手任务")
    @ApiImplicitParam(name = "userId", value = "用户ID")
    @RequestMapping(value = "listMission", method = RequestMethod.POST)
    public Json<MissionModel> listMission(@RequestParam(value = "userId") Long userId) {
        return this.missionService.listMissions(userId);
    }

    @ApiOperation("2-02-2 获取分享奖励")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID"),
            @ApiImplicitParam(name = "shareType", value = "分享类型：1:分享朋友，2:分享朋友圈 3:晒收入")
    })
    @RequestMapping(value = "shareReward", method = RequestMethod.POST)
    @TouTiaoAuth
    public Json shareReward(@RequestParam(value = "userId") Long userId,
                            @RequestParam(value = "shareType") byte shareType) {
        return this.missionService.shareReward(shareType, userId);
    }

    @ApiOperation("2-02-3 晒收入,获取用户基本信息")
    @ApiImplicitParam(name = "userId", value = "用户ID")
    @RequestMapping(value = "baskInfo", method = RequestMethod.POST)
    @TouTiaoAuth
    public Json<BaskInfoMeta> baskInfo(@RequestParam(value = "userId") Long userId) {
        return this.missionService.baskInfo(userId);
    }
}
