package com.bxm.newidea.wanzhuan.activity.controller;

import com.bxm.newidea.common.annotation.TouTiaoAuth;
import com.bxm.newidea.wanzhuan.activity.service.MoneyTreeService;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@Api(hidden = true)
@RestController
@RequestMapping("api/moneyTree")
public class MoneyTreeController {

    @Resource
    private MoneyTreeService moneyTreeService;

    /**
     * 获取摇钱树状态
     */
    @RequestMapping(value = "getMoneyTreeState", method = RequestMethod.POST)
    @TouTiaoAuth
    public Object getMoneyTreeState(@RequestParam(value = "userId") Long userId) {
        return this.moneyTreeService.getMoneyTreeState(userId);
    }

    /**
     * 收取摇钱树奖励
     */
    @RequestMapping(value = "gatherMoneyTreeReward", method = RequestMethod.POST)
    @TouTiaoAuth
    public Object gatherMoneyTreeReward(@RequestParam(value = "userId") Long userId,
                                        @RequestParam(value = "treeId") Long treeId) {
        return this.moneyTreeService.gatherMoneyTreeReward(userId, treeId);
    }

    /**
     * 获取摇钱树分享奖励
     */
    @RequestMapping(value = "gatherShareReward", method = RequestMethod.POST)
    @TouTiaoAuth
    public Object gatherShareReward(@RequestParam(value = "userId") Long userId,
                                    @RequestParam(value = "treeId") Long treeId) {
        return this.moneyTreeService.gatherShareReward(userId, treeId);
    }

    /**
     * 获取摇钱树分享信息
     */
    @RequestMapping(value = "getShareMessage", method = RequestMethod.POST)
    @TouTiaoAuth
    public Object getShareMessage(@RequestParam(value = "userId") Long userId) {
        return this.moneyTreeService.getShareMessage(userId);
    }
}
