package com.bxm.newidea.wanzhuan.activity.controller;

import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.wanzhuan.activity.vo.RedPacketInviteCount;
import com.bxm.newidea.wanzhuan.base.vo.Json;
import com.bxm.newidea.wanzhuan.points.service.RedpacketLevelService;
import com.bxm.newidea.wanzhuan.security.service.RegSourceService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import static com.bxm.newidea.wanzhuan.base.constant.UserRegChannelConstant.RED_PACKAGE;

@Api(tags = "2-04 红包分享活动相关接口")
@RestController
@RequestMapping("/api/redpacket")
public class RedPacketController extends BaseController {

    private RegSourceService regSourceService;

    private RedpacketLevelService redpacketLevelService;

    @Autowired
    public RedPacketController(RegSourceService regSourceService, RedpacketLevelService redpacketLevelService) {
        this.regSourceService = regSourceService;
        this.redpacketLevelService = redpacketLevelService;
    }

    @ApiOperation("2-04-1 获取用户通过红包邀请的有效用户总数")
    @ApiImplicitParam(name = "userId", value = "用户ID")
    @GetMapping("/invite/{userId}")
    public Json<RedPacketInviteCount> getInviteCount(@PathVariable Long userId) {
        int currentTotal = this.regSourceService.getEffectiveInviteCount(userId, RED_PACKAGE);
        int nextLevel = this.redpacketLevelService.getNextLevel(currentTotal);

        RedPacketInviteCount count = new RedPacketInviteCount(currentTotal, nextLevel);
        return Json.build(count);
    }
}
