package com.bxm.newidea.wanzhuan.base.config;

import com.aliyun.openservices.ons.api.MessageListener;
import com.aliyun.openservices.ons.api.bean.ConsumerBean;
import com.aliyun.openservices.ons.api.bean.ProducerBean;
import com.aliyun.openservices.ons.api.bean.Subscription;
import com.bxm.newidea.common.properties.AliyunMqProperties;
import com.google.common.collect.Maps;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Map;
import java.util.Properties;

/**
 * 阿里云消息队列配置
 * @author dell 2018/7/27 14:25
 */
@Component
@Configuration
public class AliyunMqConfiguration implements ApplicationContextAware {

    @Resource
    private AliyunMqProperties aliyunMqProperties;

    private ApplicationContext applicationContext;

    @Bean(initMethod = "start", destroyMethod = "shutdown")
    public ConsumerBean consumerBean() {
        ConsumerBean consumerBean = new ConsumerBean();

        Properties properties = new Properties();
        properties.setProperty("ConsumerId", this.aliyunMqProperties.getConsumerId());
        properties.setProperty("AccessKey", this.aliyunMqProperties.getAccessKey());
        properties.setProperty("SecretKey", this.aliyunMqProperties.getAccessSecret());

        consumerBean.setProperties(properties);

        Map<Subscription, MessageListener> subscriptionTable = Maps.newHashMap();

        Map<String, MessageListener> listenerMap = this.applicationContext.getBeansOfType(MessageListener.class);

        if (listenerMap.size() > 0) {
            for (MessageListener listener : listenerMap.values()) {

                Subscription subscription = new Subscription();
                subscription.setTopic(this.aliyunMqProperties.getTopic());
                subscription.setExpression("*");

                subscriptionTable.put(subscription, listener);
            }
        }

        consumerBean.setSubscriptionTable(subscriptionTable);
        return consumerBean;
    }

    @Bean(name = "producer", initMethod = "start", destroyMethod = "shutdown")
    @Lazy
    public ProducerBean producerBean() {
        ProducerBean producerBean = new ProducerBean();

        Properties properties = new Properties();
        properties.setProperty("ProducerId", this.aliyunMqProperties.getProducerId());
        properties.setProperty("AccessKey", this.aliyunMqProperties.getAccessKey());
        properties.setProperty("SecretKey", this.aliyunMqProperties.getAccessSecret());

        producerBean.setProperties(properties);

        return producerBean;
    }


    @Bean(name = "mpProducer", initMethod = "start", destroyMethod = "shutdown")
    @Lazy
    public ProducerBean mpProducer() {
        ProducerBean producerBean = new ProducerBean();

        Properties properties = new Properties();
        properties.setProperty("ProducerId", this.aliyunMqProperties.getMpProducerId());
        properties.setProperty("AccessKey", this.aliyunMqProperties.getAccessKey());
        properties.setProperty("SecretKey", this.aliyunMqProperties.getAccessSecret());

        producerBean.setProperties(properties);

        return producerBean;
    }

    @Bean(name = "onsConfig")
    public OnsConfig onsConfig() {
        OnsConfig config = new OnsConfig();

        config.setMpTopic(this.aliyunMqProperties.getMpTopic());
        config.setTopic(this.aliyunMqProperties.getTopic());

        return config;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
