package com.bxm.newidea.wanzhuan.base.listener;

import com.bxm.newidea.wanzhuan.base.service.SysConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

/**
 * 容器启动完成后进行数据库配置文件的初始化
 * @author liujia 2018/7/27 14:18
 */
@Component
public class ContextRefreshedListener implements ApplicationListener<ContextRefreshedEvent> {

    private SysConfigService sysConfigService;

    @Autowired
    public ContextRefreshedListener(SysConfigService sysConfigService) {
        this.sysConfigService = sysConfigService;
    }

    @Override
    public void onApplicationEvent(ContextRefreshedEvent contextRefreshedEvent) {
        this.sysConfigService.flushCache();
    }
}
