package com.bxm.newidea.wanzhuan.base.service;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import com.bxm.newidea.common.properties.AliyunOssProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

@Service("OSSService")
public class OSSService {

    private final static Logger log = LoggerFactory.getLogger(OSSService.class);

    private AliyunOssProperties aliyunOssProperties;

    @Autowired
    public OSSService(AliyunOssProperties aliyunOssProperties) {
        this.aliyunOssProperties = aliyunOssProperties;
    }

    public String upload(InputStream in, String path) {
        if (path.startsWith(File.separator)) {
            path = path.substring(1);
        }
        OSSClient ossClient = new OSSClient(this.aliyunOssProperties.getEndpoint(), this.aliyunOssProperties.getAccessKey(), this.aliyunOssProperties.getAccessSecret());
        PutObjectResult result = ossClient.putObject(this.aliyunOssProperties.getBucket(), this.aliyunOssProperties.getFolder() + "/" + path, in);
        ossClient.shutdown();
        return "https://" + this.aliyunOssProperties.getBucket() + "." + this.aliyunOssProperties.getEndpoint() + "/" + this.aliyunOssProperties.getFolder() + "/" + path;
    }

    public String uploadWithContentType(String url, String path) {
        if (path.startsWith(File.separator)) {
            path = path.substring(1);
        }
        try {
            URLConnection connection = new URL(url).openConnection();
            ObjectMetadata meta = new ObjectMetadata();
            meta.setContentType(connection.getContentType());
            OSSClient ossClient = new OSSClient(this.aliyunOssProperties.getEndpoint(), this.aliyunOssProperties.getAccessKey(), this.aliyunOssProperties.getAccessSecret());
            PutObjectResult result = ossClient.putObject(this.aliyunOssProperties.getBucket(), this.aliyunOssProperties.getFolder() + "/" + path, connection.getInputStream(),
                    meta);
            ossClient.shutdown();
            return "https://" + this.aliyunOssProperties.getBucket() + "." + this.aliyunOssProperties.getEndpoint() + "/" + this.aliyunOssProperties.getFolder() + "/" + path;
        } catch (IOException e) {
            log.error("", e);
            return null;
        }
    }
}
