package com.bxm.newidea.wanzhuan.base.service;

import com.bxm.newidea.wanzhuan.base.vo.QuartzInfo;
import com.bxm.newidea.wanzhuan.base.vo.QuartzInfoModel;
import com.github.pagehelper.Page;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * 定时任务详情Service
 * <p>
 * <p>
 * 未经授权不得进行修改、复制、出售及商业使用
 */

@Component
public interface QuartzInfoService {

    /**
     * 保存定时任务数据
     * @param qi
     */
    boolean save(QuartzInfo qi);

    /**
     * 修改定时任务
     * @param
     * @return
     * @throws ClassNotFoundException
     */
    void update(QuartzInfo qi) throws ClassNotFoundException;

    /**
     * 查询所有任务
     * @param result
     * @return
     */
    List<QuartzInfo> findList(Map<String, Object> result);

    /**
     * 定时任务分页查询
     * @param searchMap
     * @param current
     * @param pageSize
     * @return
     */
    Page<QuartzInfoModel> page(Map<String, Object> searchMap, int current, int pageSize);

    /**
     * 据任务标识查询任务
     * @return
     */
    QuartzInfo findByCode(String code);

    /**
     * 据条件查询定时任务详情
     * @param paramMap
     * @return
     */
    QuartzInfo findSelective(Map<String, Object> paramMap);

    boolean updateByMap(Map<String, Object> paramMap);

    QuartzInfo getById(Long id);

    abstract Object editState(Long[] ids, Byte state) throws Exception;

    abstract Object run(Long[] ids) throws Exception;
}
