package com.bxm.newidea.wanzhuan.base.service;

import com.bxm.newidea.wanzhuan.base.constant.AppConst;
import com.bxm.newidea.wanzhuan.base.service.impl.ShiyuanSender;

import java.util.HashMap;
import java.util.Map;

/**
 * 短信发送适配类
 * @author liujia
 */
public class SmsFactory {

    private static Map<Byte, SmsSender> senderMap = new HashMap<>();

    static {
        senderMap.put(AppConst.Sms.SHIYUAN, new ShiyuanSender());
    }

    public static String[] send(Byte sender, String phone, String msg) {
        if (senderMap.containsKey(sender)) {
            return senderMap.get(sender).send(phone, msg);
        }
        return new String[]{"0", "sender:" + sender + ",未找到发送者"};
    }

}
