package com.bxm.newidea.wanzhuan.base.service;


import com.bxm.newidea.wanzhuan.base.vo.SysConfig;
import com.github.pagehelper.Page;

import java.util.List;
import java.util.Map;

/**
 * User:    mcwang
 * DateTime:2016-08-04 03:26:22
 * details: 系统参数表,Service接口层
 * source:  代码生成器
 */
public interface SysConfigService {

    /**
     * 系统参数表表,插入数据
     * @param sysConfig 系统参数表类
     * @return 返回页面map
     * @throws
     * @throws Exception
     */
    long insertSysConfig(SysConfig sysConfig);

    /**
     * 系统参数表表,修改数据
     * @param sysConfig 系统参数表类
     * @return 返回页面map
     * @throws Exception
     */
    long updateSysConfig(SysConfig sysConfig);


    /**
     * 系统参数表表,查询数据
     * @param
     * @return 返回页面map
     * @throws Exception
     */
    Page<SysConfig> getSysConfigPageList(int currentPage, int pageSize, Map<String, Object> map);

    /**
     * 从数据库读取配置，刷新全局redis缓存
     */
    void flushCache();

    Page<SysConfig> querySysConfigList(String code, String name, String type, int currentPage, int pageSize);

    List<SysConfig> selectListByType();

    SysConfig selectByPrimaryKey(Long id);

    List<SysConfig> listByCode(String code);
}
