package com.bxm.newidea.wanzhuan.base.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.newidea.common.util.ResultUtil;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.wanzhuan.base.constant.AppConst;
import com.bxm.newidea.wanzhuan.base.constant.RedisContents;
import com.bxm.newidea.wanzhuan.base.domain.AppVersionMapper;
import com.bxm.newidea.wanzhuan.base.service.AppVersionService;
import com.bxm.newidea.wanzhuan.base.service.SysConfigRedis;
import com.bxm.newidea.wanzhuan.base.vo.AppVersion;
import com.bxm.newidea.wanzhuan.base.vo.PublishPackageInfoDTO;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2018/2/22 0022.
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class AppVersionServiceImpl implements AppVersionService {

    @Resource
    private AppVersionMapper appVersionMapper;

    @Resource
    private SysConfigRedis redis;

    @Override
    public AppVersion getByMobileType(Integer mobileType) {
        return this.appVersionMapper.getByMobileType(mobileType);
    }

    @Override
    public Object getPublishState(int platform, String chnl, String bundleId, String version) {
        Map<String, Object> retMap = new HashMap<>();
        retMap.put("publishState", this.auditSuccess(platform, chnl, bundleId, version) ? AppConst.STATE_USE : AppConst.STATE_DISABLE);
        return ResultUtil.genSuccessResult(retMap);
    }

    private boolean auditSuccess(Integer platform, String chnl, String bundleId, String version) {
        //1、IOS提包成功；2、渠道不在限制展示集里,正常展示
        if (AppConst.PLATFORM.IOS == platform && this.isExistPublishPackage(bundleId, version)) {
            return true;
        }
        if (AppConst.PLATFORM.ANDROID == platform && !this.isExistChannel(chnl)) {
            return true;
        }
        return false;
    }

    public boolean isExistPublishPackage(String bundleId, String version) {
        String enableBundles = this.redis.getValue(RedisContents.TYPE.SYSTEM, RedisContents.ONLINE_IOS_BINDLE);
        if (StringUtils.isBlank(enableBundles)) {
            return false;
        }
        List<PublishPackageInfoDTO> dtos = JSONArray.parseArray(enableBundles, PublishPackageInfoDTO.class);
        if (null != dtos && dtos.size() > 0 && StringUtils.isNotBlank(bundleId)) {
            for (PublishPackageInfoDTO bundle : dtos) {
                if (bundle.getBundleId().equals(bundleId) && bundle.getVersion().equals(version)) {
                    return true;
                }
            }
        }
        return false;
    }

    //安卓:是否是限制渠道
    public boolean isExistChannel(String channel) {
        String channelJson = this.redis.getValue(RedisContents.TYPE.SYSTEM, RedisContents.DISABLE_ANDROID_CHANNEL);
        if (StringUtils.isBlank(channelJson)) {
            return false;
        }
        Map<String, String> stringMap = JSONObject.parseObject(channelJson, Map.class);
        if (stringMap.containsKey(channel)) {
            return true;
        } else {
            return false;
        }
    }
}
