package com.bxm.newidea.wanzhuan.base.service.impl;

import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.wanzhuan.base.domain.MessageMapper;
import com.bxm.newidea.wanzhuan.base.enums.MessageEunm;
import com.bxm.newidea.wanzhuan.base.enums.SendStateEunm;
import com.bxm.newidea.wanzhuan.base.enums.SendTypeEunm;
import com.bxm.newidea.wanzhuan.base.service.MessageService;
import com.bxm.newidea.wanzhuan.base.vo.MPage;
import com.bxm.newidea.wanzhuan.base.vo.Message;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2018/2/9 0009.
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class MessageServiceImpl implements MessageService {

    @Resource
    private MessageMapper messageMapper;


    @Override
    public List<Message> queryList(Long userId, MPage page) {
        return this.messageMapper.queryList(userId, page);
    }

    @Override
    public int getNewMsg(Long userId) {
        int num = this.messageMapper.getNewMsg(userId);
        return num > 0 ? num : 0;
    }


    @Override
    public List<Message> queryMessageList(Map<String, Object> map) {
        List<Message> messageList = this.messageMapper.selectMsgList(map);
        for (Message message : messageList) {
            message.setTypeStr(MessageEunm.getMessageEnumByType(message.getMsgType()));
        }
        return messageList;
    }

    @Override
    public Message selectByPrimaryKey(Long id) {
        Message messageInfo = this.messageMapper.selectByPrimaryKey(id.intValue());
        if (null != messageInfo) {
            if (!StringUtils.isEmpty(String.valueOf(messageInfo.getSendType()))) {
                messageInfo.setSendTypeStr(SendTypeEunm.getSendByType(String.valueOf(messageInfo.getSendType())));
            }
            if (!StringUtils.isEmpty(String.valueOf(messageInfo.getSendState()))) {
                messageInfo.setSendStateStr(SendStateEunm.getSendByState(String.valueOf(messageInfo.getSendState())));
            }
            if (!StringUtils.isEmpty(messageInfo.getSendTime())) {
                messageInfo.setSendTime(messageInfo.getSendTime().substring(0, messageInfo.getSendTime().indexOf(".")));
            }
        }
        return messageInfo;
    }


    @Override
    public int insertSelective(Message record) {
        return this.messageMapper.insertSelective(record);
    }

    @Override
    public List<Message> queryList(String userId) {
        List<Message> messageList = this.messageMapper.selectList();
        return messageList;
    }

    @Override
    public Page<Message> queryMessageList(Map<String, Object> map, int currentPage, int pageSize) {
        PageHelper.startPage(currentPage, pageSize);
        List<Message> list = this.messageMapper.selectAdminMsgList(map);
        for (Message message : list) {
            message.setTypeStr(MessageEunm.getMessageEnumByType(message.getMsgType()));
            message.setSendTypeStr(SendTypeEunm.getSendByType(String.valueOf(message.getSendType())));
            message.setSendStateStr(SendStateEunm.getSendByState(String.valueOf(message.getSendState())));
            if (!StringUtils.isEmpty(message.getSendTime())) {
                message.setSendTime(message.getSendTime().substring(0, message.getSendTime().indexOf(".")));
            }
        }
        return (Page<Message>) list;
    }

    @Override
    public int updateByPrimaryKeySelective(Message record) {
        return this.messageMapper.updateByPrimaryKeySelective(record);
    }

    @Override
    public int deleteByPrimaryKey(Long id) {
        return this.messageMapper.deleteByPrimaryKey(id.intValue());
    }

    @Override
    public Message selectByMap(Map<String, Object> map) {
        return this.messageMapper.selectByMap(map);
    }

    @Override
    public Message selectLastOne() {
        return this.messageMapper.selectLastOne();
    }

    @Override
    public List<Message> queryNoticeList(Long userId, MPage page) {
        List<Message> list = this.messageMapper.queryNoticeList(userId, page);
        return list;
    }

    @Override
    public Message noticeDetail(Integer id) {
        return this.messageMapper.selectByPrimaryKey(id);
    }
}
