package com.bxm.newidea.wanzhuan.base.service.impl;

import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.wanzhuan.base.enums.MessageEunm;
import com.bxm.newidea.wanzhuan.base.service.MessageService;
import com.bxm.newidea.wanzhuan.base.service.PushMessageService;
import com.bxm.newidea.wanzhuan.base.vo.Message;
import com.gexin.rp.sdk.base.IPushResult;
import com.gexin.rp.sdk.base.impl.AppMessage;
import com.gexin.rp.sdk.base.impl.SingleMessage;
import com.gexin.rp.sdk.base.impl.Target;
import com.gexin.rp.sdk.base.payload.APNPayload;
import com.gexin.rp.sdk.base.uitls.AppConditions;
import com.gexin.rp.sdk.http.IGtPush;
import com.gexin.rp.sdk.template.NotificationTemplate;
import com.gexin.rp.sdk.template.style.Style0;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by Administrator on 2018/3/22 0022.
 */
@Service
@Transactional(rollbackFor = Exception.class)
public class PushMessageServiceImpl implements PushMessageService {

    private static final Logger logger = LoggerFactory.getLogger(PushMessageServiceImpl.class);

    @Resource
    private MessageService messageService;

    private String appId = "O7PPTUGSqS8MGZISC3tgw7";

    private String appSecret = "FnYlsGLWB46D5chLvaztFA";

    private String appKey = "JausQf6hFj6bjYIJh50Cz5";

    private String masterSecret = "c04e8WRKwx6jVf95rT4Zw8";

    //TODO [liujia]这里的推送需要确认是否在用
    private String host = "http://sdk.open.api.igexin.com/apiex.htm";

    @Override
    public void recruitSuccess(Long userId, String Phone) {
        String hideMobile = StringUtils.hideMobile(Phone);
        String title = "收徒通知";
        String content = "恭喜您！成功收取" + hideMobile + "用户为徒儿.";
        this.pushMsgByAlias(title, content, userId.toString(), null);
        this.insertMessage(MessageEunm.ACCEPT_APPRENTICE.getType(), title, content, userId);

    }

    @Override
    public void recruitAward(Long userId, String tribute, String apprentice, String gold, String money) {
        String title = "邀请收徒{" + apprentice + "}奖励";
        String content = "新徒弟第" + tribute + "天成功进贡" + gold + "金币，系统给您发放收徒奖励" + money + "元，收徒越多收益越高，赶快邀请好友拿奖励吧";
        this.pushMsgByAlias(title, content, userId.toString(), null);
        this.insertMessage(MessageEunm.ACCEPT_APPRENTICE.getType(), title, content, userId);
    }

    @Override
    public void discipleAward(Long userId, String tribute, String gold, String money) {
        String title = "收徒奖励";
        String content = "新徒孙第" + tribute + "天成功收益" + gold + "金币，系统给您发放收徒奖励" + money + "元，收徒越多收益越高，赶快邀请好友拿奖励吧！";
        this.pushMsgByAlias(title, content, userId.toString(), null);
        this.insertMessage(MessageEunm.ADD_DISCIPLE.getType(), title, content, userId);
    }

    @Override
    public void promotion(Long userId, String num, String grade, String percent, BigDecimal subsidy, String extra,
                          String nextGrade) {
        String title = "等级晋升通知";
        StringBuffer buffer = new StringBuffer("恭喜您收徒人数达到");
        buffer.append(num);
        buffer.append("人，成功晋升为");
        buffer.append(grade);
        buffer.append("，可享受徒弟");
        buffer.append(percent);
        buffer.append("%的进贡奖励");
        if (subsidy.compareTo(new BigDecimal(BigInteger.ZERO)) > 0) {
            buffer.append("且每月可获得额外补贴");
            buffer.append(subsidy);
            buffer.append("金币");
        }
        buffer.append("，在收取");
        buffer.append(extra);
        buffer.append("名徒弟即可晋升为");
        buffer.append(nextGrade);
        buffer.append("了哦~。");
        this.pushMsgByAlias(title, buffer.toString(), userId.toString(), null);
        this.insertMessage(MessageEunm.PROMOTION.getType(), title, buffer.toString(), userId);

    }

    @Override
    public void moneyChangeNotice(Long userId, String gold, String percent, String money) {
        String title = "昨日金币成功兑换为零钱";
        String content = "昨日共赚取" + gold + "金币，根据昨日兑换汇率" + percent + "，已成功为您兑换" + money + "元零钱，可在零钱中查看收益明细哦~";
        this.pushMsgByAlias(title, content, userId.toString(), null);
        this.insertMessage(MessageEunm.MONEY_CHANGE_NOTICE.getType(), title, content, userId);
    }

    @Override
    public void withdrawDepositSuccess(Long userId, String money, String time) {
        String title = money + "现申请支付成功";
        String content = "您于" + time + "提交的" + money + "元提现申请已通过审核，并支付成功，请注意查看提现账户到账情况，如有疑问，请联系客服。";
        this.pushMsgByAlias(title, content, userId.toString(), null);
        this.insertMessage(MessageEunm.WITHDRAW_DEPOSIT.getType(), title, content, userId);

    }

    @Override
    public void withdrawDepositFail(Long userId, String money, String time) {
        String title = money + "提现申请支付失败";
        String content = "您于" + time + "提交的" + money + "元提现申请未通过审核，请确认您的提现账户真实有效，并再次提交申请，如有疑问，请联系客服。";
        this.pushMsgByAlias(title, content, userId.toString(), null);
        this.insertMessage(MessageEunm.WITHDRAW_DEPOSIT.getType(), title, content, userId);
    }

    @Override
    public void withdrawDepositNoPass(Long userId, String money, String time) {
        String title = money + "提现申请未通过审核";
        String content = "您于" + time + "提交的" + money + "元提现申请未通过审核，如有疑问，请联系客服。";
        this.pushMsgByAlias(title, content, userId.toString(), null);
        this.insertMessage(MessageEunm.WITHDRAW_DEPOSIT.getType(), title, content, userId);

    }

    @Override
    public void wakeApprentice(Long userId, String apprenticePhone, String gold) {
        String title = "唤醒徒弟成功";
        String content = "您的徒弟" + apprenticePhone + "成功被唤醒，" + gold + "金币的唤醒奖励已发放到您的账户中，可在我的金币-收益明细中查看。";
        this.pushMsgByAlias(title, content, userId.toString(), null);
        this.insertMessage(MessageEunm.WAKE_APPRENTICE.getType(), title, content, userId);
    }

    @Override
    public void firstRecruit(Long userId, String phone, String coin) {
        String title = "首次收徒奖励";
        String content = "首次收徒" + phone + "奖励" + coin + "元已发放到您的账户中，可在我的零钱-收益明细中查看。";
        this.pushMsgByAlias(title, content, userId.toString(), null);
        this.insertMessage(MessageEunm.FIRST_RECRUIT.getType(), title, content, userId);
    }

    private void insertMessage(String type, String title, String content, Long userId) {
        Message message = new Message(userId, title, content, type);
        this.messageService.insertSelective(message);
    }

    @Override
    public void pushMsgByAlias(String title, String content, String alias, String payload_info) {
        System.setProperty("gexin.rp.sdk.pushlist.needDetails", "true");
        IGtPush push = new IGtPush(this.host, this.appKey, this.masterSecret);
        NotificationTemplate template = this.notificationTemplate(content, content, payload_info);
        SingleMessage message = new SingleMessage();
        message.setOffline(true);
        // 离线有效时间，单位为毫秒，可选
        message.setOfflineExpireTime(24 * 3600 * 1000);
        message.setData(template);
        // 可选，1为wifi，0为不限制网络环境。根据手机处于的网络情况，决定是否下发
        message.setPushNetWorkType(0);
        Target target = new Target();
        target.setAppId(this.appId);
        target.setAlias(alias);
        IPushResult ret = push.pushMessageToSingle(message, target);
        logger.info("推送----" + ret.getResponse().toString());
    }

    @Override
    public void pushMsgToAll(String title, String content, String payloadInfo) {
        IGtPush push = new IGtPush(this.host, this.appKey, this.masterSecret);
        NotificationTemplate template = this.notificationTemplate(content, content, payloadInfo);
        AppMessage message = new AppMessage();
        message.setData(template);
        message.setOffline(true);
        message.setOfflineExpireTime(24 * 1000 * 3600);
        List<String> appIdList = new ArrayList<String>();
        List<String> phoneTypeList = new ArrayList<String>();
        appIdList.add(this.appId);
        phoneTypeList.add("ANDROID");
        phoneTypeList.add("IOS");
        message.setAppIdList(appIdList);
        AppConditions cdt = new AppConditions();
        cdt.addCondition(AppConditions.PHONE_TYPE, phoneTypeList, AppConditions.OptType.or);
        message.setConditions(cdt);
        IPushResult ret = push.pushMessageToApp(message);
        logger.info("群发推送----" + ret.getResponse().toString());
    }

    @Override
    public NotificationTemplate notificationTemplate(String title, String content, String payload_info) {
        NotificationTemplate template = new NotificationTemplate();
        template.setAppId(this.appId);
        template.setAppkey(this.appKey);
        template.setTransmissionType(1);
        template.setTransmissionContent(payload_info);

        APNPayload payload = new APNPayload();
        payload.setAutoBadge("+1");
        payload.setContentAvailable(1);
        payload.setSound("default");
        APNPayload.DictionaryAlertMsg dictionaryAlertMsg = new APNPayload.DictionaryAlertMsg();
        dictionaryAlertMsg.setTitle(title);
        dictionaryAlertMsg.setBody(content);
        payload.setAlertMsg(dictionaryAlertMsg);
        payload.addCustomMsg("payload", payload_info);
        template.setAPNInfo(payload);

        Style0 style = new Style0();
        style.setTitle(title);
        style.setText(content);
        style.setRing(true);
        style.setVibrate(true);
        style.setClearable(true);
        template.setStyle(style);
        return template;
    }

}
