package com.bxm.newidea.wanzhuan.base.service.impl;

import com.bxm.newidea.common.util.ResultUtil;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.wanzhuan.base.constant.AppConst;
import com.bxm.newidea.wanzhuan.base.constant.RespCode;
import com.bxm.newidea.wanzhuan.base.domain.QuartzInfoMapper;
import com.bxm.newidea.wanzhuan.base.domain.QuartzLogMapper;
import com.bxm.newidea.wanzhuan.base.service.QuartzInfoService;
import com.bxm.newidea.wanzhuan.base.utils.BeanUtil;
import com.bxm.newidea.wanzhuan.base.utils.QuartzManager;
import com.bxm.newidea.wanzhuan.base.vo.QuartzInfo;
import com.bxm.newidea.wanzhuan.base.vo.QuartzInfoModel;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 定时任务详情ServiceImpl
 */
@Service("quartzInfoService")
public class QuartzInfoServiceImpl implements QuartzInfoService {

    private static final Logger logger = LoggerFactory.getLogger(QuartzInfoServiceImpl.class);

    @Resource
    private QuartzInfoMapper quartzInfoMapper;

    @Resource
    private QuartzLogMapper quartzLogMapper;

    @Override
    public boolean save(QuartzInfo qi) {
        int result = this.quartzInfoMapper.insert(qi);
        return result > 0;
    }

    @Override
    public void update(QuartzInfo quartzInfo) throws ClassNotFoundException {
        QuartzInfo oldInfo = this.quartzInfoMapper.selectByPrimaryKey(quartzInfo.getId());
        quartzInfo.setUpdateTime(new Date());
        this.quartzInfoMapper.updateByPrimaryKeySelective(BeanUtil.bean2map(quartzInfo, true));

        // 如果之前任务为启用状态，移除旧任务，重新添加新任务
        if (AppConst.STATE_USE.equals(oldInfo.getState())) {
            QuartzManager.removeJob(oldInfo.getCode());
            QuartzManager.addJob(quartzInfo.getCode(), Class.forName(quartzInfo.getClassName()), quartzInfo.getCycle());
        }
    }

    @Override
    public List<QuartzInfo> findList(Map<String, Object> result) {
        return this.quartzInfoMapper.findList(result);
    }

    @Override
    public Page<QuartzInfoModel> page(Map<String, Object> searchMap, int current, int pageSize) {
        PageHelper.startPage(current, pageSize);
        List<QuartzInfoModel> list = this.quartzInfoMapper.page(searchMap);
        for (QuartzInfoModel quartzInfoModel : list) {
            String lastStartTime = this.quartzLogMapper.findLastTimeByQzInfoId(quartzInfoModel.getId());
            if (StringUtils.isNotBlank(lastStartTime)) {
                quartzInfoModel.setLastStartTime(DateUtils.parseDateTime(lastStartTime));
            }
            Double success = (double) quartzInfoModel.getSucceed();
            Double fail = (double) quartzInfoModel.getFail();
            Double total = success + fail;
            if (total > 0) {
                DecimalFormat format = new DecimalFormat("0.00");
                String str = format.format(success * 100 / total);
                quartzInfoModel.setSuccessRate(str + "%");
            } else {
                quartzInfoModel.setSuccessRate("0.00%");
            }
        }
        return (Page<QuartzInfoModel>) list;
    }

    @Override
    public QuartzInfo findByCode(String code) {
        return this.quartzInfoMapper.findByCode(code);
    }

    @Override
    public QuartzInfo findSelective(Map<String, Object> paramMap) {
        return this.quartzInfoMapper.findSelective(paramMap);
    }

    @Override
    public boolean updateByMap(Map<String, Object> paramMap) {
        return this.quartzInfoMapper.updateByPrimaryKeySelective(paramMap);
    }

    @Override
    public QuartzInfo getById(Long id) {
        return this.quartzInfoMapper.selectByPrimaryKey(id);
    }

    @Override
    public Object editState(Long[] ids, Byte state) throws Exception {
        for (Long id : ids) {
            QuartzInfo quartzInfo = this.quartzInfoMapper.selectByPrimaryKey(id);
            if (quartzInfo == null) {
                return ResultUtil.genFailedResult(RespCode.PARAM_ERR, "任务不存在");
            }
            quartzInfo.setState(state);
            this.quartzInfoMapper.updateByPrimaryKey(quartzInfo);
            if (state == 10) {
                QuartzManager.removeJob(quartzInfo.getCode());
            } else {
                QuartzManager.addJob(quartzInfo.getCode(), Class.forName(quartzInfo.getClassName()),
                        quartzInfo.getCycle());
            }
        }
        return ResultUtil.genSuccessMsg();
    }

    @Override
    public Object run(Long[] ids) {
        for (Long id : ids) {
            QuartzInfo quartzInfo = this.quartzInfoMapper.selectByPrimaryKey(id);
            if (quartzInfo == null) {
                return ResultUtil.genFailedResult(RespCode.PARAM_ERR, "任务不存在");
            }
            QuartzManager.startJobNow(quartzInfo.getCode());

        }
        return ResultUtil.genSuccessMsg();
    }

}