package com.bxm.newidea.wanzhuan.base.service.impl;


import com.bxm.newidea.wanzhuan.base.domain.QuartzLogMapper;
import com.bxm.newidea.wanzhuan.base.service.QuartzLogService;
import com.bxm.newidea.wanzhuan.base.vo.QuartzLog;
import com.bxm.newidea.wanzhuan.base.vo.QuartzLogModel;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;


/**
 * 定时任务记录ServiceImpl
 * <p>
 * <p>
 * 未经授权不得进行修改、复制、出售及商业使用
 */

@Service("quartzLogService")
public class QuartzLogServiceImpl implements QuartzLogService {

    private static final Logger logger = LoggerFactory.getLogger(QuartzLogServiceImpl.class);

    @Resource
    private QuartzLogMapper quartzLogMapper;

    @Override
    public int save(QuartzLog ql) {
        return this.quartzLogMapper.insert(ql);
    }

    @Override
    public Page<QuartzLogModel> page(Map<String, Object> searchMap, int current, int pageSize) {
        PageHelper.startPage(current, pageSize);
        return (Page<QuartzLogModel>) this.quartzLogMapper.page(searchMap);
    }
}