package com.bxm.newidea.wanzhuan.base.service.impl;

import com.bcloud.msg.http.HttpSender;
import com.bxm.newidea.common.properties.SmsProperties;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.wanzhuan.base.service.SmsSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 示远短信发送服务类
 * @author liujia
 */
public class ShiyuanSender implements SmsSender {

    private final static Logger log = LoggerFactory.getLogger(ShiyuanSender.class);

    private SmsProperties smsProperties;

    private SmsProperties getSmsProperties() {
        if (this.smsProperties == null) {
            this.smsProperties = SpringContextHolder.getBean(SmsProperties.class);
        }
        return this.smsProperties;
    }

    @Override
    public String[] send(String phone, String msg) {
        String result = "";
        this.smsProperties = this.getSmsProperties();
        try {
            result = HttpSender.batchSend(this.smsProperties.getUrl(),
                    this.smsProperties.getAccount(),
                    this.smsProperties.getPwd(),
                    phone,
                    msg,
                    true,
                    "",
                    "");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return this.processResult(result);
    }

    /**
     * 短信提交响应分为两行，第一行为响应时间和提交状态，第二行为服务器给出提交messageid。无论发送的号码是多少，一个发送请求只返回一个messageid，
     * 如果响应的状态不是“0”，则没有messageid即第二行数据。（每行以换行符(0x0a,即\n)分割）
     * @param result 短信发送反馈结果
     * @return 转换后的短信
     */
    private String[] processResult(String result) {
        String[] arr = result.split("\\n");
        // String[0] 是否成功发送 string[1] 返回结果
        String[] re = new String[2];
        if (arr.length > 1) {
            re[0] = "1";
            re[1] = arr[0] + arr[1];
        } else {
            re[0] = "0";
            re[1] = arr[0];
        }
        return re;
    }
}
