package com.bxm.newidea.wanzhuan.base.service.impl;

import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redis.impl.RedisKeyGenerator;
import com.bxm.newidea.component.tools.ShortUrlGenerator;
import com.bxm.newidea.wanzhuan.base.constant.RedisContents;
import com.bxm.newidea.wanzhuan.base.service.ShortLinkService;
import com.bxm.newidea.wanzhuan.base.service.SysConfigRedis;
import com.bxm.newidea.wanzhuan.base.vo.ShortLinkReq;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;

/**
 * Created by Administrator on 2018/4/3.
 */
@Service("shortLinkService")
public class ShortLinkServiceImpl implements ShortLinkService {

    /**
     * 短链接key
     */
    public final static String SHORT_URL = "short_url";

    /**
     * 短链接host
     */
    private final static String SHORT = "t";

    @Resource
    private SysConfigRedis sysConfigRedis;

    @Resource
    private RedisStringAdapter redisStringAdapter;

    @Override
    public Map getRegisterShortUrl(ShortLinkReq req) {
        Map<String, Object> map = new HashMap<>();

        StringBuilder url = new StringBuilder();
        //渠道地址
        String channelUrl = this.sysConfigRedis.getValue(RedisContents.TYPE.SYSTEM, RedisContents.CHANNEL_URL);
        //邀请注册地址
        url.append(channelUrl).append(req.getUserId());
        map.put("sortUrl", this.getShortUrl(url.toString()));
        return map;
    }

    @Override
    public Map getDownloadShortUrl(ShortLinkReq req) {
        Map<String, Object> map = new HashMap<>();
        StringBuilder url = new StringBuilder();
        //渠道地址
        String channelUrl = this.sysConfigRedis.getValue(RedisContents.TYPE.SYSTEM, RedisContents.DOWNLOAD_URL);
        url.append(channelUrl);
        map.put("sortUrl", this.getShortUrl(url.toString()));
        return map;
    }

    @Override
    public Map getFriendSweepShortUrl(ShortLinkReq req) {
        Map<String, Object> map = new HashMap<>();
        StringBuffer url = new StringBuffer();
        //渠道地址
        String channelUrl = this.sysConfigRedis.getValue(RedisContents.TYPE.SYSTEM, RedisContents.FRIEND_SWEEP_URL);
        url.append(channelUrl).append(req.getUserId());
        map.put("sortUrl", this.getShortUrl(url.toString()));
        return map;
    }

    private String getShortUrl(String url) {
        //短连接地址
        StringBuffer sortUrl = new StringBuffer();
        String host = this.sysConfigRedis.getValue(RedisContents.TYPE.SYSTEM, RedisContents.SERVER_HOST);
        sortUrl.append(host).append("/").append(SHORT).append("/");
        String key = ShortUrlGenerator.getShortUrl(url)[0];
        sortUrl.append(key);
        //缓存180天，超时，则跳转到注册界面
        this.redisStringAdapter.set(RedisKeyGenerator.build(SHORT_URL, key), url, 3600 * 24 * 90);
        return sortUrl.toString();
    }
}
