package com.bxm.newidea.wanzhuan.base.service.impl;


import com.bxm.newidea.common.util.ResultUtil;
import com.bxm.newidea.component.tools.RandomUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.wanzhuan.base.constant.AppConst;
import com.bxm.newidea.wanzhuan.base.constant.RespCode;
import com.bxm.newidea.wanzhuan.base.domain.SmsMapper;
import com.bxm.newidea.wanzhuan.base.domain.SmsTplMapper;
import com.bxm.newidea.wanzhuan.base.service.SmsFactory;
import com.bxm.newidea.wanzhuan.base.service.SmsService;
import com.bxm.newidea.wanzhuan.base.vo.Json;
import com.bxm.newidea.wanzhuan.base.vo.Sms;
import com.bxm.newidea.wanzhuan.base.vo.SmsJson;
import com.bxm.newidea.wanzhuan.base.vo.SmsTpl;
import com.google.common.collect.Maps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.Map;


@Service
public class SmsServiceImpl implements SmsService {

    private final static Logger logger = LoggerFactory.getLogger(SmsServiceImpl.class);

    @Resource
    private SmsTplMapper smsTplMapper;

    @Resource
    private SmsMapper smsMapper;

    @Value("${spring.profiles.active:test}")
    private String profile;

    @Override
    public SmsJson sendSmsByType(Byte type, String phone, String ip) {
        if (this.isEneironment()) {
            return SmsJson.build(ResultUtil.genFailedResult(RespCode.SUCCESS, "发送成功")).setCountDown(60);
        }

        if (null != ip && this.smsSendLimit(phone, ip)) {
            return SmsJson.build(ResultUtil.genFailedResult(RespCode.PHONE_SEND_LIMIT, "该手机短信当天发送到达上限"));
        }

        Map<String, Object> search = Maps.newHashMap();
        search.put("type", type);
        search.put("states", AppConst.STATE_USE);

        //FIXME [liujia]短信模板不能每次都去数据请求，直接放到redis即可
        SmsTpl smsTpl = this.smsTplMapper.findSelective(search);

        if (smsTpl != null) {
            String msg = smsTpl.getTpl();
            if (!StringUtils.isEmpty(msg)) {

                String vcode = RandomUtils.getShortCode(6);

                Map<String, String> param = Maps.newHashMap();
                param.put("vcode", vcode);

                msg = StringUtils.convertMessage(msg, param);

                String[] result = SmsFactory.send(AppConst.Sms.SHIYUAN, phone, msg);

                this.saveSmsRecord(phone, type, ip, param, result);

                return SmsJson.build(ResultUtil.genFailedResult(RespCode.SUCCESS, "发送成功")).setCountDown(60);
            }
        }
        return SmsJson.build(ResultUtil.genFailedResult(RespCode.PARAM_ERR, "参数错误"));
    }

    /**
     * 检查短信发送数量，防止超量发送
     * @param phone 手机号码
     * @param ip    发送IP
     * @return true表示已超量
     */
    private boolean smsSendLimit(String phone, String ip) {
        Map result = this.smsMapper.getDaySendNum(ip, phone);
        Integer phoneDaySendNum = Integer.parseInt(result.get("phoneDaySendNum") + "");
        Integer ipDaySendNum = Integer.parseInt(result.get("ipDaySendNum") + "");
        return phoneDaySendNum > AppConst.Sms.PHONE_MAX_SEND_NUM
                || ipDaySendNum > AppConst.Sms.IP_MAX_SEND_NUM;
    }

    private boolean isEneironment() {
        return AppConst.ENV.DEV_STR.equals(this.profile);
    }

    @Override
    public boolean checkVcode(Byte type, String phone, String vcode) {
        if (this.isEneironment()) {
            return true;
        }
        //TODO [liujia]验证码存储存在数据库
        Sms sms = this.smsMapper.isExistVcode(phone, type, vcode);
        if (sms != null && phone.equals(sms.getPhone())) {
            sms.setState(AppConst.Sms.STATUS_USED);
            this.smsMapper.updateByPrimaryKeySelective(sms);
            return true;
        }
        return false;
    }

    private void saveSmsRecord(String phone, Byte type, String ip, Map<String, String> param, String[] result) {
        Date date = new Date();

        Sms sms = new Sms();

        sms.setPhone(phone);
        sms.setSendTime(date);
        sms.setSmsType(type);
        sms.setCode(param.get("vcode"));
        sms.setState(AppConst.Sms.STATUS_UNUSED);
        sms.setResp(result[0]);
        sms.setContent(result[1]);
        sms.setIp(ip);
        sms.setRespTime(date);
        sms.setCreateTime(date);

        this.smsMapper.insertSelective(sms);
    }


    @Override
    public SmsJson sendSms(String phone, String type) {
        Map<String, Object> search = Maps.newHashMap();
        search.put("type", type);
        search.put("states", "20");
        SmsTpl smsTpl = this.smsTplMapper.findSelective(search);
        if (smsTpl != null) {
            String msg = smsTpl.getTpl();
            if (!StringUtils.isEmpty(msg)) {
                String vcode = RandomUtils.getShortCode(4);
                Map<String, String> param = Maps.newHashMap();
                param.put("vcode", vcode);
                msg = StringUtils.convertMessage(msg, param);
                String[] result = SmsFactory.send(AppConst.Sms.SHIYUAN, phone, msg);

                this.saveSmsRecord(phone, Byte.valueOf(type), null, param, result);
                Json succ = ResultUtil.genFailedResult(RespCode.SUCCESS, "发送成功");
                return SmsJson.build(succ).setCountDown(60);
            }
        }
        return SmsJson.build(ResultUtil.genSuccessMsg());
    }

    @Override
    public int getDaySendNum(String phone, String smsType) {
        Map<String, Object> param = Maps.newHashMap();
        param.put("phone", phone);
        param.put("type", smsType);
        return this.smsMapper.getAdminDaySendNum(param);
    }
}
