package com.bxm.newidea.wanzhuan.base.service.impl;

import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redis.impl.RedisKeyGenerator;
import com.bxm.newidea.component.tools.NumberUtils;
import com.bxm.newidea.wanzhuan.base.domain.SysConfigMapper;
import com.bxm.newidea.wanzhuan.base.service.SysConfigRedis;
import com.bxm.newidea.wanzhuan.base.vo.SysConfig;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.math.BigDecimal;

/**
 * Created by Administrator on 2017/12/15.
 */
@Service("sysConfigRedis")
public class SysConfigRedisImpl implements SysConfigRedis {

    @Resource
    private SysConfigMapper sysConfigMapper;

    @Resource
    private RedisStringAdapter redisStringAdapter;

    private String getSysConfigByCode(String type, String code) {
        SysConfig sysConfig = this.sysConfigMapper.selectByCode(type, code, "20");
        String obj = null;
        if (null != sysConfig) {
            try {
                String key = type + ":" + code;
                this.redisStringAdapter.set(RedisKeyGenerator.build(key), sysConfig.getValue());
                obj = sysConfig.getValue();
            } catch (Exception e) {
                //如果redis异常，则取数据库值
                obj = sysConfig.getValue();
            }
        }
        return obj;
    }

    @Override
    public String getValue(String type, String code) {
        String key = type + ":" + code;
        String value = this.redisStringAdapter.get(RedisKeyGenerator.build(key));
        if (StringUtils.isBlank(value)) {
            value = this.getSysConfigByCode(type, code);
        }
        return value;
    }

    @Override
    public int getInt(String type, String code) {
        return NumberUtils.parseToInt(this.getValue(type, code));
    }

    @Override
    public double getDouble(String type, String code) {
        return NumberUtils.parseToDouble(this.getValue(type, code));
    }

    @Override
    public Long getLong(String type, String code) {
        return NumberUtils.parseToLong(this.getValue(type, code));
    }

    @Override
    public BigDecimal getBigDecimal(String type, String code) {
        return new BigDecimal(this.getValue(type, code));
    }
}
