package com.bxm.newidea.wanzhuan.base.service.impl;

import com.bxm.newidea.wanzhuan.base.domain.SysConfigMapper;
import com.bxm.newidea.wanzhuan.base.enums.SysTypeEnum;
import com.bxm.newidea.wanzhuan.base.service.SysConfigService;
import com.bxm.newidea.wanzhuan.base.constant.AppConst;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redis.impl.RedisKeyGenerator;
import com.bxm.newidea.wanzhuan.base.vo.SysConfig;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import org.apache.commons.collections.map.HashedMap;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * Created by Administrator on 2017/12/24.
 */

@Service("sysConfigService")
public class SysConfigServiceImpl implements SysConfigService {

    @Resource
    private SysConfigMapper sysConfigMapper;

    @Resource
    private RedisStringAdapter redisStringAdapter;

    @Override
    public long insertSysConfig(SysConfig sysConfig) {
        long count = this.sysConfigMapper.insertSelective(sysConfig);
        if (count > 0) {
            this.updateCache(sysConfig);
        }
        return count;
    }

    @Override
    public long updateSysConfig(SysConfig sysConfig) {
        long count = this.sysConfigMapper.updateByPrimaryKeySelective(sysConfig);
        if (count > 0) {
            this.updateCache(sysConfig);
        }
        return count;
    }

    @Override
    public Page<SysConfig> getSysConfigPageList(int currentPage, int pageSize, Map<String, Object> map) {
        PageHelper.startPage(currentPage, pageSize);
        List<SysConfig> sysList = this.sysConfigMapper.selectSysConfigPageList(map);
        return (Page<SysConfig>) sysList;
    }

    private void updateCache(SysConfig sysConfig) {
        String key = sysConfig.getType() + ":" + sysConfig.getCode();
        //五天
        this.redisStringAdapter.set(RedisKeyGenerator.build(key), sysConfig.getValue(), 60 * 60 * 24 * 5);
    }

    @Override
    public void flushCache() {
        List<SysConfig> sysConfigs = this.sysConfigMapper.findAll();

        for (SysConfig sysConfig : sysConfigs) {
            if (AppConst.STATE_DISABLE.equals(sysConfig.getState())) {
                //如果禁用，则删除
                String key = sysConfig.getType() + ":" + sysConfig.getCode();
                this.redisStringAdapter.remove(RedisKeyGenerator.build(key));
            } else {
                this.updateCache(sysConfig);
            }

        }
    }


    @Override
    public List<SysConfig> selectListByType() {
        List<SysConfig> typeList = this.sysConfigMapper.selectListByType();
        for (SysConfig sysConfig : typeList) {
            sysConfig.setTypeStr(SysTypeEnum.getSysTypeEnum(sysConfig.getType()));
        }
        return typeList;
    }

    @Override
    public SysConfig selectByPrimaryKey(Long id) {
        SysConfig sysConfig = this.sysConfigMapper.selectByPrimaryKey(id);
        sysConfig.setTypeStr(SysTypeEnum.getSysTypeEnum(sysConfig.getType()));
        return sysConfig;
    }

    @Override
    public Page<SysConfig> querySysConfigList(String code, String name, String type, int currentPage, int pageSize) {
        Map<String, Object> map = new HashedMap();
        map.put("code", code);
        map.put("name", name);
        map.put("type", type);
        PageHelper.startPage(currentPage, pageSize);
        List<SysConfig> sysConfigList = this.sysConfigMapper.selectSysConfigPageList(map);
        return (Page<SysConfig>) sysConfigList;
    }


    @Override
    public List<SysConfig> listByCode(String code) {
        return this.sysConfigMapper.listByCode(code);
    }

}
