package com.bxm.newidea.wanzhuan.base.utils;

import com.bxm.newidea.component.tools.StringUtils;
import com.google.common.collect.Maps;

import java.lang.reflect.Field;
import java.util.Map;

/**
 * JavaBean反射器
 * @author zhangjh
 */
public final class BeanUtil {

    private BeanUtil() {
    }

    /**
     * 将Bean中的属性反射到Map中
     * @param bean   要反射的Bean
     * @param ignore 忽略null和''
     * @return 保存字段值的集合
     */
    public static Map<String, Object> bean2map(
            Object bean, boolean ignore) {
        Map<String, Object> map = Maps.newHashMap();
        if (bean != null) {
            Class<?> clazz = bean.getClass();
            while (clazz != null && clazz != Object.class) {
                fields2map(bean, clazz.getDeclaredFields(), map, ignore);
                clazz = clazz.getSuperclass();
            }
        }
        return map;
    }

    /**
     * 遍历Map并将其反射到Bean中
     * @param map   要反射的map
     * @param clazz 返回对象类型
     * @return 保存字段值的集合
     */
    public static <T> T map2bean(
            Map<String, Object> map, Class<T> clazz) {
        if (map == null) {
            return null;
        }
        try {
            T bean = clazz.newInstance();
            Class<?> superClazz = bean.getClass();
            while (superClazz != null && superClazz != Object.class) {
                map2fields(bean, superClazz.getDeclaredFields(), map);
                superClazz = superClazz.getSuperclass();
            }
            return bean;
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void fields2map(Object bean, Field[] fields,
                                   Map<String, Object> map, boolean ignore) {
        try {
            for (int i = 0; fields != null && i < fields.length; i++) {
                fields[i].setAccessible(true);
                Object value = fields[i].get(bean);
                if (isNotNull(value) || (!ignore)) {
                    map.put(fields[i].getName(), value);
                }
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void map2fields(Object bean, Field[] fields,
                                   Map<String, Object> map) {
        try {
            for (int i = 0; fields != null && i < fields.length; i++) {
                fields[i].setAccessible(true);
                Object value = map.get(fields[i].getName());
                if (value != null) {
                    fields[i].set(bean, value);
                }
            }
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isNotNull(Object value) {
        return value != null && (!(value instanceof String) || StringUtils.isNotBlank((String) value));
    }

}