package com.bxm.newidea.wanzhuan.base.utils;

import org.quartz.*;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 定时任务动态修改
 * @author Administrator
 */
@SuppressWarnings({"rawtypes"})
public class QuartzManager {

    private static final Logger logger = LoggerFactory.getLogger(QuartzManager.class);

    private static SchedulerFactory gSchedulerFactory = new StdSchedulerFactory();

    private static String JOB_GROUP_NAME = "EXTJWEB_JOBGROUP_NAME";

    private static String TRIGGER_GROUP_NAME = "EXTJWEB_TRIGGERGROUP_NAME";

    /**
     * 添加一个定时任务，使用默认的任务组名，触发器名，触发器组名
     * @param jobName
     * @param cls
     * @param time
     */
    public static void addJob(String jobName, Class cls, String time) {

        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            // 任务名，任务组，任务执行类
            JobDetail jobDetail = JobBuilder.newJob().withIdentity(jobName, JOB_GROUP_NAME).ofType(cls).build();
            // 触发器名,触发器组
            CronTrigger trigger = TriggerBuilder.newTrigger()
                    .withSchedule(CronScheduleBuilder.cronSchedule(time))
                    .forJob(jobName, JOB_GROUP_NAME)
                    .build();
            sched.scheduleJob(jobDetail, trigger);
            // 启动
            if (!sched.isShutdown()) {
                sched.start();
            }
        } catch (SchedulerException e) {
            logger.error("", e);
        }

    }

    /**
     * 添加一个定时任务
     * @param jobName
     * @param jobGroupName
     * @param triggerName
     * @param triggerGroupName
     * @param jobClass
     * @param time
     */
    public static void addJob(String jobName, String jobGroupName,
                              String triggerName, String triggerGroupName, Class jobClass,
                              String time) {

        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            // 任务名，任务组，任务执行类
            JobDetail jobDetail = JobBuilder.newJob().withIdentity(jobName, JOB_GROUP_NAME).ofType(jobClass).build();
            // 触发器名,触发器组
            CronTrigger trigger = TriggerBuilder.newTrigger()
                    .withSchedule(CronScheduleBuilder.cronSchedule(time))
                    .forJob(triggerName, triggerGroupName)
                    .build();
            sched.scheduleJob(jobDetail, trigger);
        } catch (SchedulerException e) {
            logger.error("", e);
        }

    }

    /**
     * 修改一个任务的触发时间(使用默认的任务组名，触发器名，触发器组名)
     * @param jobName
     * @param time
     */
    public static void modifyJobTime(String jobName, String time) {

        try {
            Scheduler sched = gSchedulerFactory.getScheduler();

            CronTrigger trigger = (CronTrigger) sched.getTrigger(new TriggerKey(jobName, TRIGGER_GROUP_NAME));
            if (trigger == null) {
                return;
            }
            String oldTime = trigger.getCronExpression();
            if (!oldTime.equalsIgnoreCase(time)) {
                JobDetail jobDetail = sched.getJobDetail(new JobKey(jobName, JOB_GROUP_NAME));
                Class objJobClass = jobDetail.getJobClass();
                removeJob(jobName);

                addJob(jobName, objJobClass, time);
            }
        } catch (SchedulerException e) {
            logger.error("", e);
        }

    }

    /**
     * 修改一个任务的触发时间
     * @param triggerName
     * @param triggerGroupName
     * @param time
     */
    public static void modifyJobTime(String triggerName, String triggerGroupName, String time) {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            CronTrigger trigger = (CronTrigger) sched.getTrigger(new TriggerKey(triggerName, triggerGroupName));
            if (trigger == null) {
                return;
            }
            String oldTime = trigger.getCronExpression();
            if (!oldTime.equalsIgnoreCase(time)) {
                // 修改时间
                trigger.getTriggerBuilder().withSchedule(CronScheduleBuilder.cronSchedule(time)).build();
                // 重启触发器
                sched.resumeTrigger(new TriggerKey(triggerName, triggerGroupName));
            }
        } catch (SchedulerException e) {
            logger.error("", e);
        }

    }

    /**
     * 移除一个任务(使用默认的任务组名，触发器名，触发器组名)
     * @param jobName
     */
    public static void removeJob(String jobName) {

        removeJOb(jobName, JOB_GROUP_NAME, jobName, TRIGGER_GROUP_NAME);

    }

    /**
     * 移除一个任务
     * @param jobName
     * @param jobGroupName
     * @param triggerName
     * @param triggerGroupName
     */
    public static void removeJob(String jobName, String jobGroupName,
                                 String triggerName, String triggerGroupName) {

        removeJOb(jobName, jobGroupName, triggerName, triggerGroupName);

    }

    private static void removeJOb(String jobName, String jobGroupName, String triggerName, String triggerGroupName) {
        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            TriggerKey triggerKey = new TriggerKey(triggerName, triggerGroupName);
            // 停止触发器
            sched.pauseTrigger(triggerKey);
            // 移除触发器
            sched.unscheduleJob(triggerKey);
            JobKey jobKey = new JobKey(jobName, jobGroupName);
            // 删除任务
            sched.deleteJob(jobKey);
        } catch (SchedulerException e) {
            logger.error("", e);
        }
    }

    /**
     * 立即执行任务(使用默认的任务组名，触发器名，触发器组名)
     * @param jobName
     */
    public static void startJobNow(String jobName) {

        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            sched.triggerJob(new JobKey(jobName, JOB_GROUP_NAME));
        } catch (SchedulerException e) {
            logger.error("", e);
        }

    }

    /**
     * 立即执行任务
     * @param jobName
     * @param jobGroupName
     */
    public static void startJobNow(String jobName, String jobGroupName) {

        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            sched.triggerJob(new JobKey(jobName, jobGroupName));
        } catch (SchedulerException e) {
            logger.error("", e);
        }

    }

    /**
     * 启动所有定时任务
     */
    public static void startJobs() {

        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            sched.start();
        } catch (SchedulerException e) {
            logger.error("", e);
        }

    }

    /**
     * 关闭所有定时任务
     */
    public static void shutdownJobs() {

        try {
            Scheduler sched = gSchedulerFactory.getScheduler();
            if (!sched.isShutdown()) {
                sched.shutdown();
            }
        } catch (SchedulerException e) {
            logger.error("", e);
        }

    }

}
