package com.bxm.newidea.wanzhuan.base.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * Created by Administrator on 2018/1/8.
 */
public class TimeUtil {


    public static String formatDateByPattern(Date date, String dateFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat);
        String formatTimeStr = null;
        if (date != null) {
            formatTimeStr = sdf.format(date);
        }
        return formatTimeStr;
    }

    /***
     * convert Date to cron ,eg.  "0 07 10 15 1 ? 2016"
     * @param date  : 时间点
     * @return
     */
    public static String getCron(Date date) {
        String dateFormat = "ss mm HH dd MM ? yyyy";
        return formatDateByPattern(date, dateFormat);
    }

    public static Long getSystime(String date) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date newdate = format.parse(date);
        return newdate.getTime();
    }

    public static void main(String arg[]) {
        String cron = TimeUtil.getCron(new Date());
        Long time = null;
        try {
            time = getSystime("2018-01-15 15:08:40");
        } catch (ParseException e) {
            e.printStackTrace();
        }
        System.out.println(cron);
        System.out.println(time);

    }


}
