package com.bxm.newidea.wanzhuan.base.vo;


import com.bxm.newidea.wanzhuan.base.constant.AppConst;

import java.util.Date;

/**
 * 定时任务详情Model
 * <p>
 * <p>
 * <p>
 * 未经授权不得进行修改、复制、出售及商业使用
 */
public class QuartzInfoModel extends QuartzInfo {

    /**
     * 状态 - 禁用
     */
    public static final Byte STATE_DISABLE = 10;

    /**
     * 状态 - 启用
     */
    public static final Byte STATE_ENABLE = 20;

    private static final long serialVersionUID = 1L;

    /**
     * 任务状态描述
     */
    private String stateStr;

    /**
     * 上次执行时间
     */
    private Date lastStartTime;

    private String successRate;

    /**
     * 状态中文转换
     * @param state
     * @return
     */
    public static String stateConvert(Byte state) {
        String stateStr;
        if (AppConst.STATE_DISABLE == state) {
            stateStr = "禁用";
        } else {
            stateStr = "启用";
        }
        return stateStr;
    }

    public String getSuccessRate() {
        return this.successRate;
    }

    public void setSuccessRate(String successRate) {
        this.successRate = successRate;
    }

    /**
     * 获取任务状态描述
     * @return stateStr
     */
    public String getStateStr() {
        this.stateStr = stateConvert(this.getState());
        return this.stateStr;
    }

    /**
     * 设置任务状态描述
     * @param stateStr
     */
    public void setStateStr(String stateStr) {
        this.stateStr = stateStr;
    }

    /**
     * 获取上次执行时间
     * @return lastStartTime
     */
    public Date getLastStartTime() {
        return this.lastStartTime;
    }

    /**
     * 设置上次执行时间
     * @param lastStartTime
     */
    public void setLastStartTime(Date lastStartTime) {
        this.lastStartTime = lastStartTime;
    }


}
