/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.wanzhuan.points.service.impl;

import com.bxm.newidea.wanzhuan.activity.model.LevelConfig;
import com.bxm.newidea.wanzhuan.activity.service.LevelConfigService;
import com.bxm.newidea.wanzhuan.points.service.BusinessCalService;
import com.bxm.newidea.wanzhuan.security.model.UserInfoDTO;
import com.bxm.newidea.wanzhuan.security.service.UserService;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BusinessCalServiceImpl
implements BusinessCalService {
    private UserService userService;
    private LevelConfigService levelConfigService;

    @Autowired
    public BusinessCalServiceImpl(UserService userService, LevelConfigService levelConfigService) {
        this.userService = userService;
        this.levelConfigService = levelConfigService;
    }

    public BigDecimal calculateAttributedGold(Long userId, BigDecimal gold) {
        UserInfoDTO user = this.userService.getUserFromRedisDB(userId.longValue());
        byte level = user.getLevel();
        List levelConfigList = this.levelConfigService.getLevelConfigs();
        for (LevelConfig levelConfig : levelConfigList) {
            if (levelConfig.getLevelType() != level) continue;
            return gold.multiply(levelConfig.getContributeRate());
        }
        return gold;
    }

    public BigDecimal calculateSubsidyGold(Byte level) {
        BigDecimal ret = BigDecimal.ZERO;
        List levelConfigList = this.levelConfigService.getLevelConfigs();
        for (LevelConfig levelConfig : levelConfigList) {
            if (!levelConfig.getLevelType().equals(level)) continue;
            return levelConfig.getMonthReward();
        }
        return ret;
    }

    public int calculatePrenticeNum(Byte level) {
        int ret = 1000;
        List levelConfigList = this.levelConfigService.getLevelConfigs();
        for (LevelConfig levelConfig : levelConfigList) {
            if (!levelConfig.getLevelType().equals(level)) continue;
            return levelConfig.getPupilLimit();
        }
        return ret;
    }
}

