/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.wanzhuan.points.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.common.properties.BizConfigProperties;
import com.bxm.newidea.common.service.AbstractSplitTablePerMonthService;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.impl.RedisKeyGenerator;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.wanzhuan.activity.enums.TaskTypeEnum;
import com.bxm.newidea.wanzhuan.activity.model.InviteRelation;
import com.bxm.newidea.wanzhuan.activity.model.LevelConfig;
import com.bxm.newidea.wanzhuan.activity.service.InviteRelationService;
import com.bxm.newidea.wanzhuan.activity.service.LevelConfigService;
import com.bxm.newidea.wanzhuan.activity.service.MissionService;
import com.bxm.newidea.wanzhuan.base.constant.AppConst;
import com.bxm.newidea.wanzhuan.base.constant.RedisConfig;
import com.bxm.newidea.wanzhuan.base.enums.LevelEunm;
import com.bxm.newidea.wanzhuan.base.service.PushMessageService;
import com.bxm.newidea.wanzhuan.base.service.SysConfigRedis;
import com.bxm.newidea.wanzhuan.points.domain.PayFlowMapper;
import com.bxm.newidea.wanzhuan.points.domain.UserAmountMapper;
import com.bxm.newidea.wanzhuan.points.service.BusinessCalService;
import com.bxm.newidea.wanzhuan.points.service.PayFlowService;
import com.bxm.newidea.wanzhuan.points.service.UserRewardStatService;
import com.bxm.newidea.wanzhuan.points.vo.FlowDetail;
import com.bxm.newidea.wanzhuan.points.vo.PayFlow;
import com.bxm.newidea.wanzhuan.points.vo.UserAmount;
import com.bxm.newidea.wanzhuan.points.vo.WeekRankListVO;
import com.bxm.newidea.wanzhuan.security.model.User;
import com.bxm.newidea.wanzhuan.security.model.UserInfoDTO;
import com.bxm.newidea.wanzhuan.security.service.UserService;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="payFlowService")
public class PayFlowServiceImpl
extends AbstractSplitTablePerMonthService
implements PayFlowService {
    private static final String DEFAULT_TABLE_NAME = "a_pay_flow";
    private static Logger logger = LoggerFactory.getLogger(PayFlowServiceImpl.class);
    @Resource
    private BizConfigProperties bizConfigProperties;
    @Resource
    private PayFlowMapper payFlowMapper;
    @Resource
    private UserAmountMapper userAmountMapper;
    @Resource
    private UserRewardStatService userRewardStatService;
    @Resource
    private InviteRelationService inviteRelationService;
    @Resource
    private SysConfigRedis sysConfigRedis;
    @Resource
    private PushMessageService pushMessageService;
    @Resource
    private LevelConfigService levelConfigService;
    @Resource
    private MissionService missionService;
    @Resource
    private UserService userService;
    @Resource
    private BusinessCalService businessCalService;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;

    protected String getDefaultTableName() {
        return DEFAULT_TABLE_NAME;
    }

    protected Map<String, Object> loadTableStatus(String tableName) {
        return this.payFlowMapper.loadTableStatus(tableName);
    }

    protected void createTable(String nextTableName, long autoIncrement) {
        HashMap data = Maps.newHashMap();
        data.put("nextTableName", nextTableName);
        data.put("autoIncrement", autoIncrement);
        this.payFlowMapper.createTable(data);
    }

    protected Date customSplitTableStartMonth() {
        String startMonth = this.bizConfigProperties.getPayFlowSplitStartMonth();
        try {
            return ((DateFormat)DateUtils.PATTERN_NO_DELIMITER_WITHOUT_DAY_FORMAT.get()).parse(startMonth);
        }
        catch (ParseException e) {
            logger.error("with out payFlowSplitStartMonth," + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected void alterTableIncrement(String tableName, long autoIncrement) {
        HashMap data = Maps.newHashMap();
        data.put("tableName", tableName);
        data.put("autoIncrement", autoIncrement);
        this.payFlowMapper.alterTableIncrement(data);
    }

    public PayFlow selectByPrimaryKey(long id) {
        HashMap data = Maps.newHashMap();
        data.put("tableName", this.generateTableName(new Date()));
        data.put("id", id);
        return this.payFlowMapper.selectByPrimaryKey(data);
    }

    public int insertPayFlowRecord(PayFlow payFlow) {
        return this.payFlowMapper.insertSelective(payFlow, this.getCurrentTableName());
    }

    public void modifyAccountFlowAndStatByGold(PayFlow payFlow, BigDecimal gold, boolean isAttribute) {
        int flowSwitch = this.sysConfigRedis.getInt("SYSTEM", "flowSwitch");
        if (0 == flowSwitch) {
            return;
        }
        this.modifyAccountRelated(payFlow, gold);
        if (isAttribute) {
            this.modifyMasterAmountRelated(payFlow.getUserId(), gold);
        }
    }

    private void modifyAccountRelated(PayFlow payFlow, BigDecimal gold) {
        this.savePayFlow(payFlow, gold);
        this.userAmountMapper.updateUserAmount(payFlow.getUserId(), 10, gold, BigDecimal.ZERO);
        this.userRewardStatService.updateRewardByType(payFlow.getUserId(), payFlow.getTaskType(), gold);
    }

    private void modifyMasterAmountRelated(Long userId, BigDecimal gold) {
        InviteRelation userRelation = this.inviteRelationService.getInviteRelationByUserId(userId);
        if (userRelation != null) {
            long masterId = userRelation.getUpUserId();
            BigDecimal attributeGold = this.businessCalService.calculateAttributedGold(Long.valueOf(masterId), gold);
            PayFlow masterFlow = PayFlow.initPayFlow((Long)masterId, (Byte)TaskTypeEnum.EARNING_BY_TRIBUTE.getType(), (Byte)10, null);
            this.modifyAccountRelated(masterFlow, attributeGold);
            this.checkMasterLevel(userRelation, attributeGold);
            this.inviteRelationService.updateAttribute(userId, attributeGold);
        }
    }

    private void checkMasterLevel(InviteRelation ur, BigDecimal attributeGold) {
        BigDecimal retGold = ur.getUpReward().add(attributeGold);
        if (ur.getUpReward().compareTo(AppConst.GOLD_NUM.USER_LEVEL_UP_NUM) < 0 && retGold.compareTo(AppConst.GOLD_NUM.USER_LEVEL_UP_NUM) >= 0) {
            logger.info("\u5f92\u5f1f\u8fdb\u8d21\u8fbe\u5230100,\u6709\u6548\u5f92\u5f1f\u52a0\u4e00,userId:" + ur.getUpUserId());
            User user = this.userService.selectByPrimaryKey(ur.getUpUserId());
            int currentNum = this.inviteRelationService.countUserEffectivePrentice(ur.getUpUserId()) + 1;
            int needNum = this.businessCalService.calculatePrenticeNum(Byte.valueOf((byte)(user.getLevel() + 1)));
            if (currentNum >= needNum) {
                logger.info("\u7528\u6237\u7b49\u7ea7\u5347\u7ea7,userId:" + ur.getUpUserId());
                this.userService.upUserLevel(ur.getUpUserId());
                this.missionService.grantLevelSubsidy(user);
                UserInfoDTO userInfoDTO = this.userService.getUserRedis(ur.getUpUserId().longValue());
                if (userInfoDTO != null) {
                    userInfoDTO.setLevel((byte)(userInfoDTO.getLevel() + 1));
                    this.redisHashMapAdapter.put((KeyGenerator)RedisKeyGenerator.build((String)RedisConfig.USER_INFO), ur.getUpUserId() + "", (Object)JSON.toJSONString((Object)userInfoDTO));
                }
                LevelConfig levelConfig = this.levelConfigService.selectByPrimaryKey(Long.valueOf((long)user.getLevel().byteValue() + 1L));
                LevelConfig levelConfig2 = this.levelConfigService.selectByPrimaryKey(Long.valueOf((long)user.getLevel().byteValue() + 2L));
                this.pushMessageService.promotion(ur.getUpUserId(), currentNum + "", LevelEunm.getLevelEunm((Byte)((byte)(user.getLevel() + 1))), levelConfig.getContributeRate().multiply(new BigDecimal(100)).toString(), levelConfig.getMonthReward(), levelConfig2.getPupilLimit().toString(), LevelEunm.getLevelEunm((Byte)((byte)(user.getLevel() + 2))));
            }
        }
    }

    public void modifyAccountFlowAndStatByCoin(PayFlow payFlow, BigDecimal coin) {
        int flowSwitch = this.sysConfigRedis.getInt("SYSTEM", "flowSwitch");
        if (0 == flowSwitch) {
            return;
        }
        this.savePayFlow(payFlow, coin);
        this.userAmountMapper.updateUserAmount(payFlow.getUserId(), 20, BigDecimal.ZERO, coin);
        this.userRewardStatService.updateRewardByType(payFlow.getUserId(), payFlow.getTaskType(), coin);
    }

    public void modifyAccountByColdTransCoin(UserAmount userAmount, BigDecimal transRate) {
        int flowSwitch = this.sysConfigRedis.getInt("SYSTEM", "flowSwitch");
        if (0 == flowSwitch) {
            return;
        }
        BigDecimal transCoin = userAmount.getJbBalance().multiply(transRate).setScale(2, 4);
        PayFlow goldFlow = PayFlow.initPayFlow((Long)userAmount.getUserId(), (Byte)TaskTypeEnum.GOLD_CONVERT_TO_COIN.getType(), (Byte)10, null);
        PayFlow coinFlow = PayFlow.initPayFlow((Long)userAmount.getUserId(), (Byte)TaskTypeEnum.GOLD_CONVERT_TO_COIN.getType(), (Byte)20, null);
        this.savePayFlow(goldFlow, userAmount.getJbBalance().negate());
        this.savePayFlow(coinFlow, transCoin);
        int count = this.userAmountMapper.updateUserGoldToCoin(userAmount.getUserId(), userAmount.getJbBalance(), transCoin);
        if (count <= 0) {
            logger.error("\u91d1\u5e01\u91d1\u989d\u5c11\u4e8e\u6263\u51cf\u91d1\u5e01\u91d1\u989d,userId=" + userAmount.getUserId());
            throw new RuntimeException("gold to coin fail");
        }
        this.userRewardStatService.updateRewardByType(userAmount.getUserId(), Byte.valueOf(TaskTypeEnum.GOLD_CONVERT_TO_COIN.getType()), transCoin);
        if (transCoin.compareTo(BigDecimal.ZERO) > 0) {
            this.pushMessageService.moneyChangeNotice(userAmount.getUserId(), userAmount.getJbBalance().toString(), transRate.toString(), transCoin.toString());
        }
    }

    private void savePayFlow(PayFlow payFlow, BigDecimal reward) {
        payFlow.setReward(reward);
        payFlow.setRemark(TaskTypeEnum.getDescByType((byte)payFlow.getTaskType()));
        int i = this.payFlowMapper.insertSelective(payFlow, this.getCurrentTableName());
        if (i <= 0) {
            throw new RuntimeException("\u66f4\u65b0\u7528\u6237\u4ea4\u6613\u6d41\u6c34\u5931\u8d25");
        }
    }

    public List<FlowDetail> listPayFlowToday(Long userId, byte rewardType) {
        return this.payFlowMapper.listPayFlowToday(userId, rewardType, this.getCurrentTableName());
    }

    public BigDecimal attributeGold4OneDay(Long userId, Date awakenStartTime) {
        return this.payFlowMapper.attributeGold4OneDay(userId, awakenStartTime, this.getCurrentTableName());
    }

    public boolean hasGrantSubsidyThisMonth(Long userId, BigDecimal gold) {
        PayFlow payFlow = this.payFlowMapper.checkSubsidy(userId, TaskTypeEnum.LEVEL_REWARD_PER_MONTH.getType(), this.getCurrentTableName(), gold);
        return payFlow != null && payFlow.getReward().compareTo(gold) == 0;
    }

    public List<WeekRankListVO> getWeekRankingList() {
        Date weekStartDate = DateUtils.getWeekStartDate();
        Date currentDate = new Date();
        int weekStartMonth = DateUtils.getField((Date)weekStartDate, (int)2);
        int currentMonth = DateUtils.getField((Date)currentDate, (int)2);
        HashMap params = Maps.newHashMap();
        if (weekStartMonth != currentMonth) {
            String weekStartTableName = this.generateTableName(weekStartDate);
            params.put("weekStart", weekStartTableName);
            params.put("weekStartDate", weekStartDate);
        }
        String currentTableName = this.generateTableName(currentDate);
        params.put("currentStart", currentTableName);
        params.put("currentDate", weekStartDate);
        return this.payFlowMapper.getWeekRankingList(params);
    }
}

