/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.wanzhuan.points.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redis.impl.RedisKeyGenerator;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.wanzhuan.activity.service.InviteRelationService;
import com.bxm.newidea.wanzhuan.base.constant.RedisConfig;
import com.bxm.newidea.wanzhuan.points.domain.AmountRankingListMapper;
import com.bxm.newidea.wanzhuan.points.domain.PayFlowMapper;
import com.bxm.newidea.wanzhuan.points.domain.UserAmountMapper;
import com.bxm.newidea.wanzhuan.points.domain.UserRewardStatMapper;
import com.bxm.newidea.wanzhuan.points.service.UserAmountService;
import com.bxm.newidea.wanzhuan.points.vo.AmountRankingList;
import com.bxm.newidea.wanzhuan.points.vo.UserAmount;
import com.bxm.newidea.wanzhuan.points.vo.UserCoinRankingDTO;
import com.bxm.newidea.wanzhuan.points.vo.WeekRankListVO;
import com.bxm.newidea.wanzhuan.security.model.UserInfoDTO;
import com.bxm.newidea.wanzhuan.security.service.UserService;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="userAmountService")
public class UserAmountServiceImpl
implements UserAmountService {
    private static final Logger logger = LoggerFactory.getLogger(UserAmountServiceImpl.class);
    @Resource
    private UserAmountMapper userAmountMapper;
    @Resource
    private AmountRankingListMapper amountRankingListMapper;
    @Resource
    private InviteRelationService inviteRelationService;
    @Resource
    private UserRewardStatMapper userRewardStatMapper;
    @Resource
    private UserService userService;
    @Resource
    private PayFlowMapper payFlowMapper;
    @Resource
    private RedisStringAdapter redisStringAdapter;

    public List<AmountRankingList> selectAmountRankingList(Long userId, Byte type) {
        List<Object> rankingLists = new ArrayList();
        rankingLists = 1 == type ? this.getWeekAmountRankingList(type) : this.getAmountRankingList(type);
        this.addUserRanking(rankingLists, userId, type);
        return rankingLists;
    }

    private void addUserRanking(List<AmountRankingList> lists, Long userId, Byte type) {
        boolean flag = false;
        for (AmountRankingList rank : lists) {
            rank.setAmount(rank.getAmount().setScale(2, 4));
            if (!userId.equals(rank.getUserId())) continue;
            flag = true;
            break;
        }
        if (!flag) {
            AmountRankingList userRank = this.getAmountRankingListByUserId(userId, type);
            lists.add(0, userRank);
        }
    }

    public void getWeekRankingList() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("statDate", DateUtils.getWeekStartDate());
        List<WeekRankListVO> voList = this.userRewardStatMapper.selectWeekRewark(params);
        List<AmountRankingList> rankingLists = this.getAmountRankingList(voList, (byte)1);
        if (null != rankingLists && rankingLists.size() > 0) {
            this.amountRankingListMapper.deleteAll();
            this.amountRankingListMapper.batchAdd(rankingLists);
            this.redisStringAdapter.set((KeyGenerator)RedisKeyGenerator.build((String)RedisConfig.WEEK_RANKING), (Object)JSONArray.toJSONString(rankingLists));
        }
    }

    public UserAmount findAmountByUserId(Long userId) {
        return this.userAmountMapper.selectByUserId(userId);
    }

    public Message createAccount(Long userId) {
        return Message.build((int)this.userAmountMapper.insertSelective(new UserAmount(userId)));
    }

    public UserAmount selectByUserId(Long userId) {
        return this.userAmountMapper.selectByUserId(userId);
    }

    private List<AmountRankingList> getAmountRankingList(List<WeekRankListVO> voList, byte type) {
        if (null != voList) {
            ArrayList<AmountRankingList> rankingLists = new ArrayList<AmountRankingList>();
            for (int i = 0; i < voList.size(); ++i) {
                WeekRankListVO vo = voList.get(i);
                if (vo.getReward().compareTo(new BigDecimal(BigInteger.ZERO)) <= 0) continue;
                AmountRankingList amount = new AmountRankingList();
                int count = this.inviteRelationService.countUserPrentice(Byte.valueOf(type), vo.getUserId().longValue());
                amount.setNickname(this.userService.getUserFromRedisDB(vo.getUserId().longValue()).getNickame());
                amount.setUserId(vo.getUserId());
                amount.setAmount(vo.getReward());
                amount.setApprentices(Integer.valueOf(count));
                amount.setRanking(Integer.valueOf(i + 1));
                rankingLists.add(amount);
            }
            return rankingLists;
        }
        return null;
    }

    private List<AmountRankingList> getWeekAmountRankingList(Byte type) {
        String str = (String)this.redisStringAdapter.get((KeyGenerator)RedisKeyGenerator.build((String)RedisConfig.WEEK_RANKING));
        List<AmountRankingList> rankingLists = JSONArray.parseArray((String)str, AmountRankingList.class);
        if (null == rankingLists) {
            rankingLists = this.amountRankingListMapper.selectAll();
            this.getAmountRankingList(rankingLists, type);
        }
        return rankingLists;
    }

    private List<AmountRankingList> getAmountRankingList(Byte type) {
        String str = (String)this.redisStringAdapter.get((KeyGenerator)RedisKeyGenerator.build((String)RedisConfig.AMOUNT_RANKING));
        List<AmountRankingList> rankingLists = JSONArray.parseArray((String)str, AmountRankingList.class);
        if (null == rankingLists) {
            rankingLists = this.userAmountMapper.amountRankingList();
            this.getAmountRankingList(rankingLists, type);
            this.redisStringAdapter.set((KeyGenerator)RedisKeyGenerator.build((String)RedisConfig.AMOUNT_RANKING), (Object)JSONArray.toJSONString(rankingLists), 300L);
        }
        return rankingLists;
    }

    private void getAmountRankingList(List<AmountRankingList> rankingLists, Byte type) {
        if (null != rankingLists) {
            for (int i = 0; i < rankingLists.size(); ++i) {
                AmountRankingList amount = rankingLists.get(i);
                int count = this.inviteRelationService.countUserPrentice(type, amount.getUserId().longValue());
                UserInfoDTO dto = this.userService.getUserFromRedisDB(amount.getUserId().longValue());
                amount.setNickname(dto.getNickame());
                amount.setApprentices(Integer.valueOf(count));
                amount.setRanking(Integer.valueOf(i + 1));
            }
        }
    }

    private AmountRankingList getAmountRankingListByUserId(long userId, Byte type) {
        AmountRankingList amount = new AmountRankingList();
        amount.setUserId(Long.valueOf(userId));
        amount.setNickname(this.userService.getUserFromRedisDB(userId).getNickame());
        int count = this.inviteRelationService.countUserPrentice(type, amount.getUserId().longValue());
        amount.setApprentices(Integer.valueOf(count));
        UserCoinRankingDTO userRank = null;
        if (1 == type) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("statDate", DateUtils.getWeekStartDate());
            params.put("userId", userId);
            userRank = this.userRewardStatMapper.selectWeekRewarkByUserId(params);
        } else {
            userRank = this.userAmountMapper.selectUserRanking(userId);
        }
        if (null == userRank) {
            amount.setAmount(new BigDecimal(0));
            amount.setRanking(Integer.valueOf(99999));
        } else {
            amount.setAmount(userRank.getReward().setScale(2, 4));
            amount.setRanking(Integer.valueOf(userRank.getRowNo()));
        }
        return amount;
    }
}

