/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.wanzhuan.points.service.impl;

import com.alibaba.fastjson.JSON;
import com.bxm.newidea.common.util.ResultUtil;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redis.impl.RedisKeyGenerator;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.wanzhuan.activity.enums.TaskTypeEnum;
import com.bxm.newidea.wanzhuan.activity.model.InviteRelation;
import com.bxm.newidea.wanzhuan.activity.model.PrenticeRankingModel;
import com.bxm.newidea.wanzhuan.activity.service.InviteRelationService;
import com.bxm.newidea.wanzhuan.base.constant.RedisConfig;
import com.bxm.newidea.wanzhuan.base.service.SysConfigRedis;
import com.bxm.newidea.wanzhuan.points.domain.UserAmountMapper;
import com.bxm.newidea.wanzhuan.points.domain.UserRewardStatMapper;
import com.bxm.newidea.wanzhuan.points.enums.CoinRewardTypeEnum;
import com.bxm.newidea.wanzhuan.points.enums.GoldRewadTypeEnum;
import com.bxm.newidea.wanzhuan.points.service.AmountRewardService;
import com.bxm.newidea.wanzhuan.points.service.BusinessCalService;
import com.bxm.newidea.wanzhuan.points.service.PayFlowService;
import com.bxm.newidea.wanzhuan.points.service.UserRewardStatService;
import com.bxm.newidea.wanzhuan.points.vo.CoinInfoModel;
import com.bxm.newidea.wanzhuan.points.vo.GoldCoinDetailModel;
import com.bxm.newidea.wanzhuan.points.vo.GoldInfoModel;
import com.bxm.newidea.wanzhuan.points.vo.PrenticeStatModel;
import com.bxm.newidea.wanzhuan.points.vo.UserAmount;
import com.bxm.newidea.wanzhuan.points.vo.UserRewardStat;
import com.bxm.newidea.wanzhuan.points.vo.WaitReward;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UserRewardStatServiceImpl
implements UserRewardStatService {
    private static final Logger logger = LoggerFactory.getLogger(UserRewardStatServiceImpl.class);
    @Resource
    private UserRewardStatMapper userRewardStatMapper;
    @Resource
    private UserAmountMapper userAmountMapper;
    @Resource
    private InviteRelationService inviteRelationService;
    @Resource
    private SysConfigRedis sysConfigRedis;
    @Resource
    private AmountRewardService amountRewardService;
    @Resource
    private BusinessCalService businessCalService;
    @Resource
    private RedisStringAdapter redisStringAdapter;
    @Resource
    private RedisHashMapAdapter redisHashMapAdapter;
    private PayFlowService payFlowService;

    private PayFlowService getPayFlowService() {
        if (null == this.payFlowService) {
            this.payFlowService = (PayFlowService)SpringContextHolder.getBean(PayFlowService.class);
        }
        return this.payFlowService;
    }

    public void updateRewardByType(Long userId, Byte taskType, BigDecimal retGold) {
        UserRewardStat stat = this.userRewardStatMapper.selectDailyStat(userId, new Date());
        if (stat == null) {
            stat = UserRewardStat.initUserRewardStat(userId, this.userAmountMapper.getIdByUserId(userId));
            this.injectValueByTaskType(stat, taskType, retGold, userId);
            this.userRewardStatMapper.insertSelective(stat);
        } else {
            UserRewardStat newStat = new UserRewardStat();
            newStat.setId(stat.getId());
            newStat.setUpdateTime(new Date());
            this.injectValueByTaskType(newStat, taskType, retGold, userId);
            this.userRewardStatMapper.updateRewardByType(newStat);
        }
    }

    private void injectValueByTaskType(UserRewardStat stat, Byte taskType, BigDecimal retGold, Long userId) {
        String[] tableColumByType;
        for (String column : tableColumByType = TaskTypeEnum.getTableColumByType((byte)taskType)) {
            try {
                Field field = stat.getClass().getDeclaredField(column);
                field.setAccessible(true);
                if ("tribute".equals(column)) {
                    InviteRelation inviteRelation = this.inviteRelationService.getInviteRelationByUserId(userId);
                    if (null == inviteRelation) continue;
                    BigDecimal tributeGold = this.businessCalService.calculateAttributedGold(inviteRelation.getUpUserId(), retGold);
                    field.set(stat, tributeGold);
                    continue;
                }
                field.set(stat, retGold);
            }
            catch (Exception e) {
                logger.info("inject reward value error ", (Throwable)e);
            }
        }
    }

    public Object prenticeStatDaily(Long userId) {
        PrenticeStatModel model = this.listRewardStatInfo(userId);
        return ResultUtil.genSuccessResult((Object)model);
    }

    private PrenticeStatModel listRewardStatInfo(Long userId) {
        String prenticeDaily = RedisConfig.RewardStat.REWARD_PRENTICE + ":" + userId;
        String result = (String)this.redisStringAdapter.get((KeyGenerator)RedisKeyGenerator.build((String)prenticeDaily));
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return (PrenticeStatModel)JSON.parseObject((String)result, PrenticeStatModel.class);
        }
        BigDecimal totalTribute = this.inviteRelationService.getTotalAttributedGold(userId);
        BigDecimal rewardToday = this.userRewardStatMapper.getAttributeGoldToday(userId);
        PrenticeStatModel statModel = this.getRewardYesterday(userId);
        statModel.setAccumulateGold(totalTribute == null ? BigDecimal.ZERO : totalTribute);
        statModel.setGoldToday(rewardToday == null ? BigDecimal.ZERO : rewardToday);
        statModel.setMaster(this.getMasterInfo(userId));
        statModel.setPrenticeList(this.userRewardStatMapper.getPrenticesInfo(userId));
        this.redisStringAdapter.set((KeyGenerator)RedisKeyGenerator.build((String)RedisConfig.RewardStat.REWARD_PRENTICE), (Object)JSON.toJSONString((Object)statModel), 600L);
        return statModel;
    }

    private PrenticeStatModel getRewardYesterday(Long userId) {
        PrenticeStatModel statModel;
        RedisKeyGenerator key = RedisKeyGenerator.build((String)RedisConfig.RewardStat.REWARD_YESTERDAY);
        String rewardYesterday = (String)this.redisHashMapAdapter.get((KeyGenerator)key, userId.toString());
        if (StringUtils.isNotBlank((CharSequence)rewardYesterday)) {
            statModel = (PrenticeStatModel)JSON.parseObject((String)rewardYesterday, PrenticeStatModel.class);
        } else {
            statModel = this.userRewardStatMapper.getRewardYesterday(userId);
            if (statModel == null) {
                statModel = new PrenticeStatModel();
                statModel.setGoldYesterday(BigDecimal.ZERO);
                statModel.setCoinYesterday(BigDecimal.ZERO.setScale(2, 4));
            }
            this.redisHashMapAdapter.put((KeyGenerator)key, userId.toString(), (Object)JSON.toJSONString((Object)statModel));
            this.redisHashMapAdapter.expire((KeyGenerator)key, (long)DateUtils.getCurSeconds());
        }
        return statModel;
    }

    private PrenticeStatModel.Master getMasterInfo(Long userId) {
        RedisKeyGenerator masterKey = RedisKeyGenerator.build((String)(RedisConfig.RewardStat.MASTER_INFO + ":" + userId));
        String masterRet = (String)this.redisStringAdapter.get((KeyGenerator)masterKey);
        if (StringUtils.isBlank((CharSequence)masterRet)) {
            PrenticeStatModel.Master master = this.userRewardStatMapper.getMasterInfo(userId);
            if (master == null) {
                return null;
            }
            this.redisStringAdapter.set((KeyGenerator)masterKey, (Object)JSON.toJSONString((Object)master), 600L);
            return master;
        }
        return (PrenticeStatModel.Master)JSON.parseObject((String)masterRet, PrenticeStatModel.Master.class);
    }

    public Object displineStatDaily(Long userId) {
        return ResultUtil.genSuccessResult((Object)this.initDisplineStatDaily(userId));
    }

    private PrenticeStatModel initDisplineStatDaily(Long userId) {
        RedisKeyGenerator rewardStatKey = RedisKeyGenerator.build((String)RedisConfig.RewardStat.REWARD_DISPLINE);
        String rewardStat = (String)this.redisHashMapAdapter.get((KeyGenerator)rewardStatKey, userId.toString());
        if (StringUtils.isBlank((CharSequence)rewardStat)) {
            BigDecimal totalCoin = this.inviteRelationService.getTotalDisplineCoin(userId);
            BigDecimal rewardToday = this.userRewardStatMapper.getDisplineCoinToday(userId);
            List<PrenticeStatModel.Disciple> discipleList = this.selectDiscipleInfo(userId);
            RedisKeyGenerator key = RedisKeyGenerator.build((String)RedisConfig.RewardStat.REWARD_YESTERDAY);
            String rewardYesterday = (String)this.redisHashMapAdapter.get((KeyGenerator)rewardStatKey, userId.toString());
            PrenticeStatModel statModel = StringUtils.isBlank((CharSequence)rewardYesterday) ? this.userRewardStatMapper.getRewardYesterday(userId) : (PrenticeStatModel)JSON.parseObject((String)rewardYesterday, PrenticeStatModel.class);
            if (statModel == null) {
                statModel = new PrenticeStatModel();
                statModel.setCoinYesterday(BigDecimal.ZERO.setScale(2, 4));
                statModel.setGoldYesterday(BigDecimal.ZERO);
                this.redisHashMapAdapter.put((KeyGenerator)key, userId.toString(), (Object)JSON.toJSONString((Object)statModel));
                this.redisHashMapAdapter.expire((KeyGenerator)key, (long)DateUtils.getCurSeconds());
            }
            statModel.setAccumulateCoin(totalCoin == null ? BigDecimal.ZERO.setScale(2, 4) : totalCoin.setScale(2, 4));
            statModel.setCoinToday(rewardToday == null ? BigDecimal.ZERO.setScale(2, 4) : rewardToday.setScale(2, 4));
            statModel.setDiscipleList(discipleList);
            this.redisHashMapAdapter.put((KeyGenerator)rewardStatKey, userId.toString(), (Object)JSON.toJSONString((Object)statModel));
            this.redisHashMapAdapter.expire((KeyGenerator)rewardStatKey, (long)DateUtils.getCurSeconds());
            return statModel;
        }
        return (PrenticeStatModel)JSON.parseObject((String)rewardStat, PrenticeStatModel.class);
    }

    public void updateRedisDisplineInfo(WaitReward record, BigDecimal reward) {
        int flowSwitch = this.sysConfigRedis.getInt("SYSTEM", "flowSwitch");
        if (0 == flowSwitch) {
            return;
        }
        RedisKeyGenerator rewardStatKey = RedisKeyGenerator.build((String)RedisConfig.RewardStat.REWARD_DISPLINE);
        String rewardStat = (String)this.redisHashMapAdapter.get((KeyGenerator)rewardStatKey, record.getUserId().toString());
        if (StringUtils.isBlank((CharSequence)rewardStat)) {
            this.initDisplineStatDaily(record.getUserId());
        } else {
            PrenticeStatModel statModel = (PrenticeStatModel)JSON.parseObject((String)rewardStat, PrenticeStatModel.class);
            statModel.addAccumulateCoin(reward);
            statModel.addCoinToday(reward);
            List discipleList = statModel.getDiscipleList();
            if (discipleList != null && !discipleList.isEmpty()) {
                for (PrenticeStatModel.Disciple disciple : discipleList) {
                    if (!disciple.getId().toString().equals(record.getRelationId())) continue;
                    disciple.addUserCoin(reward);
                }
            }
            this.redisHashMapAdapter.put((KeyGenerator)rewardStatKey, record.getUserId().toString(), (Object)JSON.toJSONString((Object)statModel));
            this.redisHashMapAdapter.expire((KeyGenerator)rewardStatKey, (long)DateUtils.getCurSeconds());
        }
    }

    public Object myGoldStat(Long userId) {
        UserAmount account = this.userAmountMapper.selectByUserId(userId);
        BigDecimal goldYesterday = this.userRewardStatMapper.getRewardGoldYesterday(userId);
        List flows = this.getPayFlowService().listPayFlowToday(userId, (byte)10);
        GoldInfoModel goldInfoModel = new GoldInfoModel(account.getJbBalance(), goldYesterday, flows);
        return ResultUtil.genSuccessResult((Object)goldInfoModel);
    }

    public Object myGoldDetail(Long userId) throws IllegalAccessException {
        GoldRewadTypeEnum[] values;
        HashMap<String, Serializable> retMap = new HashMap<String, Serializable>();
        UserRewardStat yesterday = this.userRewardStatMapper.selectRewardDetail(userId);
        if (yesterday == null) {
            yesterday = new UserRewardStat();
            retMap.put("totalGold", BigDecimal.ZERO);
        } else {
            retMap.put("totalGold", yesterday.getGoldReward() == null ? BigDecimal.ZERO : yesterday.getGoldReward());
        }
        List<GoldCoinDetailModel> detail = new ArrayList<GoldCoinDetailModel>();
        for (GoldRewadTypeEnum typeEnum : values = GoldRewadTypeEnum.values()) {
            detail = this.invokeGoldFieldByType(typeEnum, yesterday, detail);
        }
        retMap.put("goldDetail", (Serializable)((Object)detail));
        return ResultUtil.genSuccessResult(retMap);
    }

    public Object myCoinStat(Long userId) {
        UserAmount account = this.userAmountMapper.selectByUserId(userId);
        BigDecimal coinYesterday = this.userRewardStatMapper.getRewardCoinYesterday(userId);
        BigDecimal rate = this.amountRewardService.getTransformRate();
        rate = rate.multiply(new BigDecimal(100)).setScale(2, 4);
        List flows = this.getPayFlowService().listPayFlowToday(userId, (byte)20);
        CoinInfoModel coinInfoModel = new CoinInfoModel(account.getRmbBalance().setScale(2, 4), coinYesterday, rate.toString(), flows);
        return ResultUtil.genSuccessResult((Object)coinInfoModel);
    }

    public Object myCoinDetail(Long userId) throws IllegalAccessException {
        CoinRewardTypeEnum[] values;
        HashMap<String, Serializable> retMap = new HashMap<String, Serializable>();
        UserRewardStat yesterday = this.userRewardStatMapper.selectCoinDetail(userId);
        if (yesterday == null) {
            yesterday = new UserRewardStat();
            retMap.put("totalCoin", BigDecimal.ZERO);
        } else {
            retMap.put("totalCoin", yesterday.getMoneyReward() == null ? BigDecimal.ZERO : yesterday.getMoneyReward());
        }
        List<GoldCoinDetailModel> detail = new ArrayList<GoldCoinDetailModel>();
        for (CoinRewardTypeEnum typeEnum : values = CoinRewardTypeEnum.values()) {
            detail = this.invokeCoinFieldByType(typeEnum, yesterday, detail);
        }
        retMap.put("coinDetail", (Serializable)((Object)detail));
        return ResultUtil.genSuccessResult(retMap);
    }

    public Object topRanking() {
        RedisKeyGenerator topKey = RedisKeyGenerator.build((String)"topRanking");
        String result = (String)this.redisStringAdapter.get((KeyGenerator)topKey);
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return ResultUtil.genSuccessResult((Object)JSON.parseArray((String)result, PrenticeRankingModel.class));
        }
        List list = this.inviteRelationService.listTopRanking();
        for (PrenticeRankingModel model : list) {
            model.setPhone(StringUtils.hideMobile((String)model.getPhone()));
            if (!StringUtils.isBlank((CharSequence)model.getHeadImg())) continue;
            model.setHeadImg((String)this.redisHashMapAdapter.get((KeyGenerator)RedisKeyGenerator.build((String)"BUSINESS"), "morentouxiang"));
        }
        this.redisStringAdapter.set((KeyGenerator)topKey, (Object)JSON.toJSONString((Object)list), 1800L);
        return ResultUtil.genSuccessResult((Object)list);
    }

    public List<PrenticeStatModel.Prentice> getPrenticesInfo(Long userId) {
        return this.userRewardStatMapper.getPrenticesInfo(userId);
    }

    public List<PrenticeStatModel.Disciple> selectDiscipleInfo(Long userId) {
        return this.userRewardStatMapper.selectDiscipleInfo(userId);
    }

    public PrenticeStatModel.Master getBasicInfo(Long userId) {
        return this.userRewardStatMapper.getBasicInfo(userId);
    }

    private List<GoldCoinDetailModel> invokeGoldFieldByType(GoldRewadTypeEnum typeEnum, UserRewardStat yesterday, List<GoldCoinDetailModel> detail) throws IllegalAccessException {
        Field[] declaredFields;
        for (Field field : declaredFields = UserRewardStat.class.getDeclaredFields()) {
            BigDecimal ret;
            if (!typeEnum.getField().equals(field.getName())) continue;
            field.setAccessible(true);
            Object value = field.get(yesterday);
            if (null == value || !StringUtils.isNotBlank((CharSequence)value.toString()) || (ret = new BigDecimal(value.toString())).compareTo(BigDecimal.ZERO) == 0) continue;
            String desc = typeEnum.getDesc();
            GoldCoinDetailModel detailModel = new GoldCoinDetailModel(desc, ret);
            detail.add(detailModel);
        }
        return detail;
    }

    private List<GoldCoinDetailModel> invokeCoinFieldByType(CoinRewardTypeEnum typeEnum, UserRewardStat yesterday, List<GoldCoinDetailModel> detail) throws IllegalAccessException {
        Field[] declaredFields;
        for (Field field : declaredFields = UserRewardStat.class.getDeclaredFields()) {
            BigDecimal ret;
            if (!typeEnum.getField().equals(field.getName())) continue;
            field.setAccessible(true);
            Object value = field.get(yesterday);
            if (null == value || !StringUtils.isNotBlank((CharSequence)value.toString()) || (ret = new BigDecimal(value.toString())).compareTo(BigDecimal.ZERO) == 0) continue;
            String desc = typeEnum.getDesc();
            GoldCoinDetailModel detailModel = new GoldCoinDetailModel(desc, ret);
            detail.add(detailModel);
        }
        return detail;
    }
}

