/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.wanzhuan.points.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.newidea.common.properties.BizConfigProperties;
import com.bxm.newidea.component.tools.NumberUtils;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.wanzhuan.activity.enums.TaskTypeEnum;
import com.bxm.newidea.wanzhuan.activity.service.InviteRelationService;
import com.bxm.newidea.wanzhuan.base.service.PushMessageService;
import com.bxm.newidea.wanzhuan.points.domain.UserRewardStatMapper;
import com.bxm.newidea.wanzhuan.points.domain.WaitRewardMapper;
import com.bxm.newidea.wanzhuan.points.domain.WaitRewardRecordMapper;
import com.bxm.newidea.wanzhuan.points.service.PayFlowService;
import com.bxm.newidea.wanzhuan.points.service.UserRewardStatService;
import com.bxm.newidea.wanzhuan.points.service.WaitRewardService;
import com.bxm.newidea.wanzhuan.points.vo.EchartData;
import com.bxm.newidea.wanzhuan.points.vo.PayFlow;
import com.bxm.newidea.wanzhuan.points.vo.Series;
import com.bxm.newidea.wanzhuan.points.vo.TotalSeries;
import com.bxm.newidea.wanzhuan.points.vo.UserRewardStat;
import com.bxm.newidea.wanzhuan.points.vo.UserRewardStatDTO;
import com.bxm.newidea.wanzhuan.points.vo.WaitReward;
import com.bxm.newidea.wanzhuan.points.vo.WaitRewardRecord;
import com.bxm.newidea.wanzhuan.points.vo.XAxis;
import com.bxm.newidea.wanzhuan.points.vo.Yaxis;
import com.bxm.newidea.wanzhuan.security.model.UserInfoDTO;
import com.bxm.newidea.wanzhuan.security.service.UserService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="waitRewardService")
public class WaitRewardServiceImpl
implements WaitRewardService {
    private static final Logger logger = LoggerFactory.getLogger(WaitRewardServiceImpl.class);
    @Resource
    private WaitRewardMapper waitRewardMapper;
    @Resource
    private WaitRewardRecordMapper waitRewardRecordMapper;
    @Resource
    private PayFlowService payFlowService;
    @Resource
    private UserRewardStatService userRewardStatService;
    @Resource
    private InviteRelationService inviteRelationService;
    @Resource
    private UserRewardStatMapper userRewardStatMapper;
    @Resource
    private UserService userService;
    @Resource
    private PushMessageService pushMessageService;
    @Resource
    private BizConfigProperties bizConfigProperties;

    private static void listSort(List<UserRewardStatDTO> list) {
        list.sort((o1, o2) -> {
            SimpleDateFormat format = new SimpleDateFormat("MM-dd");
            try {
                Date dt1 = format.parse(o1.getStatDate());
                Date dt2 = format.parse(o2.getStatDate());
                if (dt1.getTime() > dt2.getTime()) {
                    return -1;
                }
                if (dt1.getTime() < dt2.getTime()) {
                    return 1;
                }
                return 0;
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        });
    }

    private int addWaitReward(WaitReward waitReward) {
        this.waitRewardMapper.insertSelective(waitReward);
        WaitRewardRecord waitRecord = new WaitRewardRecord();
        waitRecord.setWaitId(waitReward.getId());
        waitRecord.setSendState(waitReward.getSendState());
        waitRecord.setSendTime(waitReward.getSendTime());
        waitRecord.setReward(waitReward.getReward());
        waitRecord.setRewardType(waitReward.getRewardType());
        waitRecord.setRemark(waitReward.getRemark());
        this.waitRewardRecordMapper.insertSelective(waitRecord);
        return 1;
    }

    private int addRecruitReward(WaitReward waitReward) {
        this.waitRewardMapper.insertSelective(waitReward);
        String[] rewards = this.bizConfigProperties.getAddRecruitRewardList().split("\\+");
        List<WaitRewardRecord> recordList = this.batch(waitReward, rewards);
        this.waitRewardRecordMapper.batchAdd(recordList);
        return 1;
    }

    private int addDiscipleReward(WaitReward waitReward) {
        this.waitRewardMapper.insertSelective(waitReward);
        String[] rewards = this.bizConfigProperties.getAddDiscipleRewardList().split("\\+");
        List<WaitRewardRecord> recordList = this.batch(waitReward, rewards);
        this.waitRewardRecordMapper.batchAdd(recordList);
        return 1;
    }

    private List<WaitRewardRecord> batch(WaitReward waitReward, String[] rewards) {
        ArrayList<WaitRewardRecord> recordList = new ArrayList<WaitRewardRecord>();
        for (String reward : rewards) {
            WaitRewardRecord waitRecord = new WaitRewardRecord();
            BigDecimal bd = new BigDecimal(reward);
            waitRecord.setWaitId(waitReward.getId());
            waitRecord.setSendState(waitReward.getSendState());
            waitRecord.setSendTime(waitReward.getSendTime());
            waitRecord.setReward(bd);
            waitRecord.setRewardType(waitReward.getRewardType());
            waitRecord.setRemark(waitReward.getRemark());
            recordList.add(waitRecord);
        }
        return recordList;
    }

    public int addWaitReward(TaskTypeEnum taskType, WaitReward waitReward) {
        switch (taskType.getType()) {
            case 2: 
            case 6: {
                this.addRecruitReward(waitReward);
                break;
            }
            case 7: {
                this.addDiscipleReward(waitReward);
                break;
            }
            default: {
                this.addWaitReward(waitReward);
            }
        }
        return 1;
    }

    public EchartData getProfitDetails(Long userId, int type) {
        ArrayList<String> legend = new ArrayList<String>(Arrays.asList("\u91d1\u5e01\u660e\u7ec6", "\u96f6\u94b1\u660e\u7ec6"));
        HashedMap tooltip = new HashedMap();
        tooltip.put("trigger", "axis");
        HashedMap grid = new HashedMap();
        grid.put("left", "3%");
        grid.put("right", "4%");
        grid.put("bottom", "3%");
        grid.put("containLabel", "true");
        HashedMap yAxis = new HashedMap();
        yAxis.put("type", "true");
        ArrayList<XAxis> xAxis = new ArrayList<XAxis>();
        List<UserRewardStatDTO> presentRecord = this.userRewardStatMapper.selectPresentRecord(userId, type);
        List<UserRewardStatDTO> moneyRecord = this.userRewardStatMapper.selectMoneyRecord(userId, type);
        UserRewardStatDTO maxRecord = this.userRewardStatMapper.selectMaxRecord(userId, type);
        ArrayList<String> moneyList = new ArrayList<String>();
        ArrayList<String> goldList = new ArrayList<String>();
        List dayList = null;
        if (type == 1) {
            dayList = NumberUtils.getIntervals((int)7);
            xAxis.add(new XAxis("category", NumberUtils.getIntervals((int)7)));
        } else if (type == 2) {
            dayList = NumberUtils.getIntervals((int)15);
            xAxis.add(new XAxis("category", NumberUtils.getIntervals((int)15)));
        } else {
            dayList = NumberUtils.getIntervals((int)30);
            xAxis.add(new XAxis("category", NumberUtils.getIntervals((int)30)));
        }
        LinkedHashMap<String, UserRewardStatDTO> map = new LinkedHashMap<String, UserRewardStatDTO>();
        for (UserRewardStatDTO userRewardStat : moneyRecord) {
            map.put(userRewardStat.getStatDate(), userRewardStat);
        }
        for (String s : dayList) {
            if (map.containsKey(s)) continue;
            UserRewardStatDTO userRewardStat = new UserRewardStatDTO();
            userRewardStat.setStatDate(s);
            userRewardStat.setGoldReward(new BigDecimal(0));
            userRewardStat.setMoneyReward(new BigDecimal(0));
            map.put(s, userRewardStat);
        }
        moneyRecord.clear();
        moneyRecord.addAll(map.values());
        WaitRewardServiceImpl.listSort(moneyRecord);
        for (UserRewardStatDTO userRewardStatDTO : moneyRecord) {
            moneyList.add(userRewardStatDTO.getMoneyReward().toString());
            goldList.add(userRewardStatDTO.getGoldReward().toString());
        }
        ArrayList<TotalSeries> totalSeries = new ArrayList<TotalSeries>();
        totalSeries.add(new TotalSeries("\u6536\u76ca\u660e\u7ec6", "line", presentRecord));
        ArrayList<Series> series = new ArrayList<Series>();
        series.add(new Series("\u91d1\u5e01\u660e\u7ec6", "line", goldList));
        series.add(new Series("\u96f6\u94b1\u660e\u7ec6", "line", moneyList));
        ArrayList<Yaxis> yaxis = new ArrayList<Yaxis>();
        ArrayList<String> axisLabel = new ArrayList<String>();
        axisLabel.add("{value} \u5143");
        ArrayList<String> newaxisLabel = new ArrayList<String>();
        newaxisLabel.add("{value} \u91d1\u5e01");
        yaxis.add(new Yaxis("\u91d1\u5e01", "'value", Double.valueOf(0.0), Double.valueOf(maxRecord.getGoldReward().doubleValue()), 50, newaxisLabel));
        yaxis.add(new Yaxis("\u96f6\u94b1", "'value", Double.valueOf(0.0), Double.valueOf(maxRecord.getMoneyReward().doubleValue()), 50, axisLabel));
        EchartData data = new EchartData();
        data.setLegend(legend);
        data.setTooltip((Map)tooltip);
        data.setxAxis(xAxis);
        data.setGrid((Map)grid);
        data.setyAxis(yaxis);
        data.setSeries(series);
        data.setTotalseries(totalSeries);
        return data;
    }

    public void grantWaitReward(WaitReward waitReward, BigDecimal awark) {
        List<WaitRewardRecord> recordList = this.waitRewardRecordMapper.findSelectiveByWaitId(waitReward.getId());
        if (null == recordList || recordList.size() == 0) {
            waitReward.setSendState(Byte.valueOf((byte)1));
            this.waitRewardMapper.updateByPrimaryKeySelective(waitReward);
            return;
        }
        WaitRewardRecord record = recordList.get(0);
        PayFlow payFlow = PayFlow.initPayFlow((Long)waitReward.getUserId(), (Byte)waitReward.getTaskType(), (Byte)waitReward.getRewardType(), (String)record.getId().toString());
        if (20 == waitReward.getRewardType()) {
            this.payFlowService.modifyAccountFlowAndStatByCoin(payFlow, record.getReward());
        } else if (10 == waitReward.getRewardType()) {
            this.payFlowService.modifyAccountFlowAndStatByGold(payFlow, record.getReward(), false);
        } else {
            logger.error("\u5b9a\u65f6\u5f85\u6d3e\u53d1\u5956\u52b1,\u652f\u4ed8\u7c7b\u578b\u9519\u8bef" + waitReward.getRewardType());
        }
        if (recordList.size() == 1) {
            waitReward.setSendState(Byte.valueOf((byte)1));
            waitReward.setUpdateTime(new Date());
            this.waitRewardMapper.updateByPrimaryKeySelective(waitReward);
            record.setSendState((byte)1);
            record.setUpdateTime(new Date());
            this.waitRewardRecordMapper.updateByPrimaryKeySelective(record);
        } else {
            record.setSendState((byte)1);
            record.setUpdateTime(new Date());
            this.waitRewardRecordMapper.updateByPrimaryKeySelective(record);
            waitReward.setUpdateTime(new Date());
            this.waitRewardMapper.updateByPrimaryKeySelective(waitReward);
        }
        this.pushRewardMessage(waitReward, record, awark);
        if (TaskTypeEnum.ADD_DISCIPLE.getType() == waitReward.getTaskType().byteValue()) {
            this.inviteRelationService.updateUpUpCoin(record.getReward(), Long.valueOf(waitReward.getRelationId()));
            this.userRewardStatService.updateRedisDisplineInfo(waitReward, record.getReward());
        }
    }

    private void pushRewardMessage(WaitReward waitReward, WaitRewardRecord record, BigDecimal awark) {
        try {
            if (TaskTypeEnum.ADD_RECRUIT.getType() == waitReward.getTaskType().byteValue()) {
                int count = this.waitRewardRecordMapper.selectCountByWaitId(waitReward.getId());
                UserInfoDTO apprenticeDto = this.userService.getUserFromRedisDB(Long.valueOf(waitReward.getRelationId()).longValue());
                UserRewardStat stat = this.userRewardStatMapper.selectDailyStat(apprenticeDto.getId(), new Date());
                this.pushMessageService.recruitAward(waitReward.getUserId(), count + "", StringUtils.hideMobile((String)apprenticeDto.getPhone()), awark.toEngineeringString(), record.getReward().toString());
            } else if (TaskTypeEnum.ADD_DISCIPLE.getType() == waitReward.getTaskType().byteValue()) {
                int count = this.waitRewardRecordMapper.selectCountByWaitId(waitReward.getId());
                this.pushMessageService.discipleAward(waitReward.getUserId(), count + "", awark.toString(), record.getReward().toString());
            } else if (TaskTypeEnum.RECRUIT_FIRST.getType() == waitReward.getTaskType().byteValue()) {
                int count = this.waitRewardRecordMapper.selectCountByWaitId(waitReward.getId());
                this.pushMessageService.discipleAward(waitReward.getUserId(), count + "", awark.toString(), record.getReward().toString());
            }
        }
        catch (Exception e) {
            logger.error("\u63a8\u9001\u5931\u8d25,info=" + JSONObject.toJSONString((Object)waitReward));
        }
    }
}

