/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.newidea.wanzhuan.points.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bxm.newidea.common.properties.BizConfigProperties;
import com.bxm.newidea.common.util.NidGeneratorUtil;
import com.bxm.newidea.common.util.ResultUtil;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisStringAdapter;
import com.bxm.newidea.component.redis.impl.RedisKeyGenerator;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.bxm.newidea.component.tools.StringUtils;
import com.bxm.newidea.wanzhuan.base.exception.BusinessException;
import com.bxm.newidea.wanzhuan.base.service.PushMessageService;
import com.bxm.newidea.wanzhuan.base.service.SysConfigRedis;
import com.bxm.newidea.wanzhuan.points.domain.UserAmountMapper;
import com.bxm.newidea.wanzhuan.points.domain.WithdrawChannelMapper;
import com.bxm.newidea.wanzhuan.points.domain.WithdrawFlowMapper;
import com.bxm.newidea.wanzhuan.points.service.PayService;
import com.bxm.newidea.wanzhuan.points.service.WithdrawService;
import com.bxm.newidea.wanzhuan.points.vo.WithdrawFlow;
import com.bxm.newidea.wanzhuan.security.model.UserInfoDTO;
import com.bxm.newidea.wanzhuan.security.service.UserService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WithdrawServiceImpl
implements WithdrawService {
    private static final Logger logger = LoggerFactory.getLogger(WithdrawServiceImpl.class);
    @Resource
    private WithdrawFlowMapper withdrawFlowMapper;
    @Resource
    private WithdrawChannelMapper withdrawChannelMapper;
    @Resource
    private UserAmountMapper userAmountMapper;
    @Resource
    private SysConfigRedis sysConfigRedis;
    @Resource
    private UserService userService;
    @Resource
    private PushMessageService pushMessageService;
    @Resource
    private BizConfigProperties bizConfigProperties;
    @Resource
    private RedisStringAdapter redisStringAdapter;

    @Override
    public Object withdrawIndex(Long userId) {
        BigDecimal rmbBalance = this.userAmountMapper.getRmbBalance(userId);
        String fee = this.sysConfigRedis.getValue("SYSTEM", "withdraw_service_fee");
        UserInfoDTO dto = this.userService.getUserFromRedisDB(userId.longValue());
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("coin", rmbBalance);
        ret.put("fee", fee);
        ret.put("account", dto.getWeixin());
        return ResultUtil.genSuccessResult(ret);
    }

    @Override
    public Page<WithdrawFlow> withdrawRecord(Integer current, Integer pageSize, Long userId) {
        PageHelper.startPage((int)(current == null ? 1 : current), (int)(pageSize == null ? 10 : pageSize));
        List<WithdrawFlow> recordList = this.withdrawFlowMapper.listRecords(userId);
        return (Page)recordList;
    }

    @Override
    public List<String> findWithdrawFlow() {
        RedisKeyGenerator withdrawFlowKey = RedisKeyGenerator.build((String)"withdrawFlow");
        List<String> list = Lists.newArrayList();
        String str = (String)this.redisStringAdapter.get((KeyGenerator)withdrawFlowKey);
        if (StringUtils.isNotEmpty((CharSequence)str)) {
            list = JSONArray.parseArray((String)str, String.class);
            return list;
        }
        List<WithdrawFlow> flowList = this.withdrawFlowMapper.findWithdrawFlow();
        if (null != flowList && flowList.size() > 0) {
            for (WithdrawFlow flow : flowList) {
                String maskPhone = StringUtils.hideMobile((String)this.userService.getUserFromRedisDB(flow.getUserId().longValue()).getPhone());
                String channelName = flow.getPayChannel().toString();
                if (flow.getPayChannel() == 1L) {
                    channelName = "\u5fae\u4fe1";
                } else if (flow.getPayChannel() == 2L) {
                    channelName = "\u652f\u4ed8\u5b9d";
                }
                String buffer = "\u7528\u6237" + maskPhone + "\u901a\u8fc7" + channelName + "\u63d0\u73b0" + flow.getAmount() + "\u5143";
                list.add(buffer);
            }
        }
        if (list.size() > 0) {
            this.redisStringAdapter.set((KeyGenerator)withdrawFlowKey, (Object)JSONObject.toJSONString(list), 300L);
            return list;
        }
        return null;
    }

    @Override
    public Object withdrawApply(Long userId, int payType, double amount, String realName, String account) {
        String[] amoutArray;
        BigDecimal fee;
        BigDecimal actualAmount;
        String orderPrefix = "OTHER";
        if (1 == payType) {
            UserInfoDTO dto = this.userService.getUserFromRedisDB(userId.longValue());
            if (StringUtils.isBlank((CharSequence)dto.getWeixin())) {
                return ResultUtil.genFailedResult((int)513, (String)"\u8bf7\u7ed1\u5b9a\u5fae\u4fe1\u8d26\u53f7");
            }
            orderPrefix = "WX";
        } else if (2 == payType) {
            orderPrefix = "ALI";
        }
        Long channelId = this.withdrawChannelMapper.getChannelIdByType(payType);
        if (channelId == null) {
            return ResultUtil.genFailedResult((String)"\u63d0\u73b0\u6e20\u9053\u4e0d\u5b58\u5728");
        }
        BigDecimal rmb = this.userAmountMapper.getRmbBalance(userId);
        if (rmb.compareTo(actualAmount = new BigDecimal(amount).add(fee = this.sysConfigRedis.getBigDecimal("SYSTEM", "withdraw_service_fee"))) < 0) {
            return ResultUtil.genFailedResult((String)"\u8d26\u6237\u4f59\u989d\u4e0d\u8db3");
        }
        for (String s : amoutArray = this.bizConfigProperties.getWithdrawAmount().split(",")) {
            if (new BigDecimal(s).compareTo(new BigDecimal(amount)) != 0) continue;
            WithdrawFlow flow = new WithdrawFlow(NidGeneratorUtil.getOrderNo((String)orderPrefix), userId, channelId, realName, account, new BigDecimal(amount), fee, Byte.valueOf((byte)1), "");
            this.withdrawFlowMapper.insertSelective(flow);
            int flag = this.userAmountMapper.minusUserCoin(flow.getUserId(), actualAmount);
            if (flag != 1) {
                logger.error("\u63d0\u73b0\u8d26\u6237\u6263\u51cf\u5931\u8d25,userId:" + userId + ",\u8d26\u6237\u91d1\u989d:" + rmb + ",\u53d6\u73b0\u91d1\u989d:" + actualAmount);
                throw new BusinessException("\u63d0\u73b0\u5931\u8d25");
            }
            RedisKeyGenerator key = RedisKeyGenerator.build((String)("withdraw:" + userId));
            this.redisStringAdapter.set((KeyGenerator)key, (Object)userId.toString(), 15L);
            return ResultUtil.genSuccessResult();
        }
        return ResultUtil.genFailedResult((String)"\u63d0\u73b0\u91d1\u989d\u5f02\u5e38");
    }

    @Override
    public Object orderReview(Long orderId, byte state) {
        WithdrawFlow flow = this.withdrawFlowMapper.selectByPrimaryKey(orderId);
        if (flow == null || 1 != flow.getState()) {
            return ResultUtil.genFailedResult((String)"\u8ba2\u5355\u5df2\u5ba1\u6838\u5b8c\u6210");
        }
        if (3 == state) {
            PayService payService = (PayService)SpringContextHolder.getBean((String)this.withdrawChannelMapper.getImpl(flow.getPayChannel()));
            return payService.withdrawExecute(flow);
        }
        this.updateOrder(flow, (byte)5, "\u5ba1\u6838\u4e0d\u901a\u8fc7");
        this.pushMessageService.withdrawDepositNoPass(flow.getUserId(), flow.getAmount().toString(), flow.getCreateTime().toString());
        return ResultUtil.genSuccessResult();
    }

    private void updateOrder(WithdrawFlow flow, byte state, String remark) {
        flow.setState(Byte.valueOf(state));
        flow.setUpdateTime(new Date());
        flow.setRemark(remark);
        this.withdrawFlowMapper.updateByPrimaryKeySelective(flow);
        this.userAmountMapper.plusUserCoin(flow.getUserId(), flow.getAmount().add(flow.getFee()));
    }
}

